// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDatasetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset import job to describe.
	//
	// DatasetImportJobArn is a required field
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetImportJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDatasetImportJobInput"}

	if s.DatasetImportJobArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetImportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDatasetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about the dataset import job, including the status.
	//
	// The status is one of the following values:
	//
	//    * CREATE PENDING
	//
	//    * CREATE IN_PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	DatasetImportJob *DatasetImportJob `locationName:"datasetImportJob" type:"structure"`
}

// String returns the string representation
func (s DescribeDatasetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDatasetImportJob = "DescribeDatasetImportJob"

// DescribeDatasetImportJobRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Describes the dataset import job created by CreateDatasetImportJob, including
// the import job status.
//
//    // Example sending a request using DescribeDatasetImportJobRequest.
//    req := client.DescribeDatasetImportJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetImportJob
func (c *Client) DescribeDatasetImportJobRequest(input *DescribeDatasetImportJobInput) DescribeDatasetImportJobRequest {
	op := &aws.Operation{
		Name:       opDescribeDatasetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetImportJobInput{}
	}

	req := c.newRequest(op, input, &DescribeDatasetImportJobOutput{})

	return DescribeDatasetImportJobRequest{Request: req, Input: input, Copy: c.DescribeDatasetImportJobRequest}
}

// DescribeDatasetImportJobRequest is the request type for the
// DescribeDatasetImportJob API operation.
type DescribeDatasetImportJobRequest struct {
	*aws.Request
	Input *DescribeDatasetImportJobInput
	Copy  func(*DescribeDatasetImportJobInput) DescribeDatasetImportJobRequest
}

// Send marshals and sends the DescribeDatasetImportJob API request.
func (r DescribeDatasetImportJobRequest) Send(ctx context.Context) (*DescribeDatasetImportJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDatasetImportJobResponse{
		DescribeDatasetImportJobOutput: r.Request.Data.(*DescribeDatasetImportJobOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDatasetImportJobResponse is the response type for the
// DescribeDatasetImportJob API operation.
type DescribeDatasetImportJobResponse struct {
	*DescribeDatasetImportJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDatasetImportJob request.
func (r *DescribeDatasetImportJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
