// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeFilterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the filter to describe.
	//
	// FilterArn is a required field
	FilterArn *string `locationName:"filterArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeFilterInput"}

	if s.FilterArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeFilterOutput struct {
	_ struct{} `type:"structure"`

	// The filter's details.
	Filter *Filter `locationName:"filter" type:"structure"`
}

// String returns the string representation
func (s DescribeFilterOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeFilter = "DescribeFilter"

// DescribeFilterRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Describes a filter's properties.
//
//    // Example sending a request using DescribeFilterRequest.
//    req := client.DescribeFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFilter
func (c *Client) DescribeFilterRequest(input *DescribeFilterInput) DescribeFilterRequest {
	op := &aws.Operation{
		Name:       opDescribeFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFilterInput{}
	}

	req := c.newRequest(op, input, &DescribeFilterOutput{})

	return DescribeFilterRequest{Request: req, Input: input, Copy: c.DescribeFilterRequest}
}

// DescribeFilterRequest is the request type for the
// DescribeFilter API operation.
type DescribeFilterRequest struct {
	*aws.Request
	Input *DescribeFilterInput
	Copy  func(*DescribeFilterInput) DescribeFilterRequest
}

// Send marshals and sends the DescribeFilter API request.
func (r DescribeFilterRequest) Send(ctx context.Context) (*DescribeFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeFilterResponse{
		DescribeFilterOutput: r.Request.Data.(*DescribeFilterOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeFilterResponse is the response type for the
// DescribeFilter API operation.
type DescribeFilterResponse struct {
	*DescribeFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeFilter request.
func (r *DescribeFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
