// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes a custom algorithm.
type Algorithm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm.
	AlgorithmArn *string `locationName:"algorithmArn" type:"string"`

	// The URI of the Docker container for the algorithm image.
	AlgorithmImage *AlgorithmImage `locationName:"algorithmImage" type:"structure"`

	// The date and time (in Unix time) that the algorithm was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Specifies the default hyperparameters, their ranges, and whether they are
	// tunable. A tunable hyperparameter can have its value determined during hyperparameter
	// optimization (HPO).
	DefaultHyperParameterRanges *DefaultHyperParameterRanges `locationName:"defaultHyperParameterRanges" type:"structure"`

	// Specifies the default hyperparameters.
	DefaultHyperParameters map[string]string `locationName:"defaultHyperParameters" type:"map"`

	// Specifies the default maximum number of training jobs and parallel training
	// jobs.
	DefaultResourceConfig map[string]string `locationName:"defaultResourceConfig" type:"map"`

	// The date and time (in Unix time) that the algorithm was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the algorithm.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The training input mode.
	TrainingInputMode *string `locationName:"trainingInputMode" type:"string"`
}

// String returns the string representation
func (s Algorithm) String() string {
	return awsutil.Prettify(s)
}

// Describes an algorithm image.
type AlgorithmImage struct {
	_ struct{} `type:"structure"`

	// The URI of the Docker container for the algorithm image.
	//
	// DockerURI is a required field
	DockerURI *string `locationName:"dockerURI" type:"string" required:"true"`

	// The name of the algorithm image.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s AlgorithmImage) String() string {
	return awsutil.Prettify(s)
}

// When the solution performs AutoML (performAutoML is true in CreateSolution),
// Amazon Personalize determines which recipe, from the specified list, optimizes
// the given metric. Amazon Personalize then uses that recipe for the solution.
type AutoMLConfig struct {
	_ struct{} `type:"structure"`

	// The metric to optimize.
	MetricName *string `locationName:"metricName" type:"string"`

	// The list of candidate recipes.
	RecipeList []string `locationName:"recipeList" type:"list"`
}

// String returns the string representation
func (s AutoMLConfig) String() string {
	return awsutil.Prettify(s)
}

// When the solution performs AutoML (performAutoML is true in CreateSolution),
// specifies the recipe that best optimized the specified metric.
type AutoMLResult struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the best recipe.
	BestRecipeArn *string `locationName:"bestRecipeArn" type:"string"`
}

// String returns the string representation
func (s AutoMLResult) String() string {
	return awsutil.Prettify(s)
}

// Contains information on a batch inference job.
type BatchInferenceJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch inference job.
	BatchInferenceJobArn *string `locationName:"batchInferenceJobArn" type:"string"`

	// The time at which the batch inference job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If the batch inference job failed, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The ARN of the filter used on the batch inference job.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The Amazon S3 path that leads to the input data used to generate the batch
	// inference job.
	JobInput *BatchInferenceJobInput `locationName:"jobInput" type:"structure"`

	// The name of the batch inference job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The Amazon S3 bucket that contains the output data generated by the batch
	// inference job.
	JobOutput *BatchInferenceJobOutput `locationName:"jobOutput" type:"structure"`

	// The time at which the batch inference job was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The number of recommendations generated by the batch inference job. This
	// number includes the error messages generated for failed input records.
	NumResults *int64 `locationName:"numResults" type:"integer"`

	// The ARN of the Amazon Identity and Access Management (IAM) role that requested
	// the batch inference job.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The Amazon Resource Name (ARN) of the solution version from which the batch
	// inference job was created.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the batch inference job. The status is one of the following
	// values:
	//
	//    * PENDING
	//
	//    * IN PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s BatchInferenceJob) String() string {
	return awsutil.Prettify(s)
}

// The input configuration of a batch inference job.
type BatchInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The URI of the Amazon S3 location that contains your input data. The Amazon
	// S3 bucket must be in the same region as the API endpoint you are calling.
	//
	// S3DataSource is a required field
	S3DataSource *S3DataConfig `locationName:"s3DataSource" type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchInferenceJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchInferenceJobInput"}

	if s.S3DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output configuration parameters of a batch inference job.
type BatchInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// Information on the Amazon S3 bucket in which the batch inference job's output
	// is stored.
	//
	// S3DataDestination is a required field
	S3DataDestination *S3DataConfig `locationName:"s3DataDestination" type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchInferenceJobOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchInferenceJobOutput"}

	if s.S3DataDestination == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3DataDestination"))
	}
	if s.S3DataDestination != nil {
		if err := s.S3DataDestination.Validate(); err != nil {
			invalidParams.AddNested("S3DataDestination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A truncated version of the BatchInferenceJob datatype. The ListBatchInferenceJobs
// operation returns a list of batch inference job summaries.
type BatchInferenceJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch inference job.
	BatchInferenceJobArn *string `locationName:"batchInferenceJobArn" type:"string"`

	// The time at which the batch inference job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If the batch inference job failed, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the batch inference job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The time at which the batch inference job was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The ARN of the solution version used by the batch inference job.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the batch inference job. The status is one of the following
	// values:
	//
	//    * PENDING
	//
	//    * IN PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s BatchInferenceJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes a deployed solution version, otherwise known as a campaign. For
// more information on campaigns, see CreateCampaign.
type Campaign struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string `locationName:"campaignArn" type:"string"`

	// The date and time (in Unix format) that the campaign was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a campaign fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix format) that the campaign was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Provides a summary of the properties of a campaign update. For a complete
	// listing, call the DescribeCampaign API.
	LatestCampaignUpdate *CampaignUpdateSummary `locationName:"latestCampaignUpdate" type:"structure"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second.
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer"`

	// The name of the campaign.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of a specific version of the solution.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the campaign.
	//
	// A campaign can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s Campaign) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the properties of a campaign. For a complete listing,
// call the DescribeCampaign API.
type CampaignSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string `locationName:"campaignArn" type:"string"`

	// The date and time (in Unix time) that the campaign was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a campaign fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the campaign was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the campaign.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the campaign.
	//
	// A campaign can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s CampaignSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the properties of a campaign update. For a complete
// listing, call the DescribeCampaign API.
type CampaignUpdateSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the campaign update was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a campaign update fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the campaign update was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second that Amazon Personalize will support.
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the deployed solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the campaign update.
	//
	// A campaign update can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s CampaignUpdateSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides the name and range of a categorical hyperparameter.
type CategoricalHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`

	// A list of the categories for the hyperparameter.
	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s CategoricalHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Provides the name and range of a continuous hyperparameter.
type ContinuousHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *float64 `locationName:"maxValue" type:"double"`

	// The minimum allowable value for the hyperparameter.
	MinValue *float64 `locationName:"minValue" type:"double"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s ContinuousHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousHyperParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContinuousHyperParameterRange"}
	if s.MaxValue != nil && *s.MaxValue < -1e+06 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxValue", -1e+06))
	}
	if s.MinValue != nil && *s.MinValue < -1e+06 {
		invalidParams.Add(aws.NewErrParamMinValue("MinValue", -1e+06))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the data source that contains the data to upload to a dataset.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The path to the Amazon S3 bucket where the data that you want to upload to
	// your dataset is stored. For example:
	//
	// s3://bucket-name/training-data.csv
	DataLocation *string `locationName:"dataLocation" type:"string"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// Provides metadata for a dataset.
type Dataset struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset that you want metadata for.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// One of the following values:
	//
	//    * Interactions
	//
	//    * Items
	//
	//    * Users
	DatasetType *string `locationName:"datasetType" type:"string"`

	// A time stamp that shows when the dataset was updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ARN of the associated schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`

	// The status of the dataset.
	//
	// A dataset can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// A dataset group is a collection of related datasets (Interactions, User,
// and Item). You create a dataset group by calling CreateDatasetGroup. You
// then create a dataset and add it to a dataset group by calling CreateDataset.
// The dataset group is used to create and train a solution by calling CreateSolution.
// A dataset group can contain only one of each type of dataset.
//
// You can specify an AWS Key Management Service (KMS) key to encrypt the datasets
// in the group.
type DatasetGroup struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset group.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// If creating a dataset group fails, provides the reason why.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt the datasets.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The last update date and time (in Unix time) of the dataset group.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ARN of the IAM role that has permissions to create the dataset group.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The current status of the dataset group.
	//
	// A dataset group can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetGroup) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the properties of a dataset group. For a complete listing,
// call the DescribeDatasetGroup API.
type DatasetGroupSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset group was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// If creating a dataset group fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the dataset group was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the dataset group.
	//
	// A dataset group can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes a job that imports training data from a data source (Amazon S3
// bucket) to an Amazon Personalize dataset. For more information, see CreateDatasetImportJob.
//
// A dataset import job can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
type DatasetImportJob struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset import job.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon S3 bucket that contains the training data to import.
	DataSource *DataSource `locationName:"dataSource" type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset that receives the imported
	// data.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The ARN of the dataset import job.
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string"`

	// If a dataset import job fails, provides the reason why.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the import job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The date and time (in Unix time) the dataset was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The ARN of the AWS Identity and Access Management (IAM) role that has permissions
	// to read from the Amazon S3 data source.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The status of the dataset import job.
	//
	// A dataset import job can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetImportJob) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the properties of a dataset import job. For a complete
// listing, call the DescribeDatasetImportJob API.
type DatasetImportJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset import job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset import job.
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string"`

	// If a dataset import job fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the dataset import job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The date and time (in Unix time) that the dataset was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The status of the dataset import job.
	//
	// A dataset import job can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetImportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes the schema for a dataset. For more information on schemas, see
// CreateSchema.
type DatasetSchema struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the schema was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The date and time (in Unix time) that the schema was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the schema.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The schema.
	Schema *string `locationName:"schema" type:"string"`

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`
}

// String returns the string representation
func (s DatasetSchema) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the properties of a dataset schema. For a complete
// listing, call the DescribeSchema API.
type DatasetSchemaSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the schema was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The date and time (in Unix time) that the schema was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the schema.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`
}

// String returns the string representation
func (s DatasetSchemaSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the properties of a dataset. For a complete listing,
// call the DescribeDataset API.
type DatasetSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The dataset type. One of the following values:
	//
	//    * Interactions
	//
	//    * Items
	//
	//    * Users
	//
	//    * Event-Interactions
	DatasetType *string `locationName:"datasetType" type:"string"`

	// The date and time (in Unix time) that the dataset was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the dataset.
	//
	// A dataset can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides the name and default range of a categorical hyperparameter and whether
// the hyperparameter is tunable. A tunable hyperparameter can have its value
// determined during hyperparameter optimization (HPO).
type DefaultCategoricalHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// Whether the hyperparameter is tunable.
	IsTunable *bool `locationName:"isTunable" type:"boolean"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`

	// A list of the categories for the hyperparameter.
	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s DefaultCategoricalHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Provides the name and default range of a continuous hyperparameter and whether
// the hyperparameter is tunable. A tunable hyperparameter can have its value
// determined during hyperparameter optimization (HPO).
type DefaultContinuousHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// Whether the hyperparameter is tunable.
	IsTunable *bool `locationName:"isTunable" type:"boolean"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *float64 `locationName:"maxValue" type:"double"`

	// The minimum allowable value for the hyperparameter.
	MinValue *float64 `locationName:"minValue" type:"double"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s DefaultContinuousHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Specifies the hyperparameters and their default ranges. Hyperparameters can
// be categorical, continuous, or integer-valued.
type DefaultHyperParameterRanges struct {
	_ struct{} `type:"structure"`

	// The categorical hyperparameters and their default ranges.
	CategoricalHyperParameterRanges []DefaultCategoricalHyperParameterRange `locationName:"categoricalHyperParameterRanges" type:"list"`

	// The continuous hyperparameters and their default ranges.
	ContinuousHyperParameterRanges []DefaultContinuousHyperParameterRange `locationName:"continuousHyperParameterRanges" type:"list"`

	// The integer-valued hyperparameters and their default ranges.
	IntegerHyperParameterRanges []DefaultIntegerHyperParameterRange `locationName:"integerHyperParameterRanges" type:"list"`
}

// String returns the string representation
func (s DefaultHyperParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// Provides the name and default range of a integer-valued hyperparameter and
// whether the hyperparameter is tunable. A tunable hyperparameter can have
// its value determined during hyperparameter optimization (HPO).
type DefaultIntegerHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// Indicates whether the hyperparameter is tunable.
	IsTunable *bool `locationName:"isTunable" type:"boolean"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *int64 `locationName:"maxValue" type:"integer"`

	// The minimum allowable value for the hyperparameter.
	MinValue *int64 `locationName:"minValue" type:"integer"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s DefaultIntegerHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Provides information about an event tracker.
type EventTracker struct {
	_ struct{} `type:"structure"`

	// The Amazon AWS account that owns the event tracker.
	AccountId *string `locationName:"accountId" type:"string"`

	// The date and time (in Unix format) that the event tracker was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that receives the event
	// data.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The ARN of the event tracker.
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string"`

	// The date and time (in Unix time) that the event tracker was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the event tracker.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the event tracker.
	//
	// An event tracker can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`

	// The ID of the event tracker. Include this ID in requests to the PutEvents
	// (https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
	// API.
	TrackingId *string `locationName:"trackingId" type:"string"`
}

// String returns the string representation
func (s EventTracker) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the properties of an event tracker. For a complete
// listing, call the DescribeEventTracker API.
type EventTrackerSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the event tracker was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the event tracker.
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string"`

	// The date and time (in Unix time) that the event tracker was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the event tracker.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the event tracker.
	//
	// An event tracker can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s EventTrackerSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides feature transformation information. Feature transformation is the
// process of modifying raw input data into a form more suitable for model training.
type FeatureTransformation struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the feature transformation.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Provides the default parameters for feature transformation.
	DefaultParameters map[string]string `locationName:"defaultParameters" type:"map"`

	// The Amazon Resource Name (ARN) of the FeatureTransformation object.
	FeatureTransformationArn *string `locationName:"featureTransformationArn" type:"string"`

	// The last update date and time (in Unix time) of the feature transformation.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the feature transformation.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the feature transformation.
	//
	// A feature transformation can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s FeatureTransformation) String() string {
	return awsutil.Prettify(s)
}

// Contains information on a recommendation filter, including its ARN, status,
// and filter expression.
type Filter struct {
	_ struct{} `type:"structure"`

	// The time at which the filter was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The ARN of the dataset group to which the filter belongs.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// If the filter failed, the reason for its failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The ARN of the filter.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// Specifies the type of item interactions to filter out of recommendation results.
	// The filter expression must follow the following format:
	//
	// EXCLUDE itemId WHERE INTERACTIONS.event_type in ("EVENT_TYPE")
	//
	// Where "EVENT_TYPE" is the type of event to filter out. For more information,
	// see Using Filters with Amazon Personalize.
	FilterExpression *string `locationName:"filterExpression" min:"1" type:"string" sensitive:"true"`

	// The time at which the filter was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the filter.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the filter.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// A short summary of a filter's attributes.
type FilterSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the filter was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The ARN of the dataset group to which the filter belongs.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// If the filter failed, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The ARN of the filter.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The time at which the filter was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the filter.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the filter.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s FilterSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes the properties for hyperparameter optimization (HPO). For use with
// the bring-your-own-recipe feature. Do not use for Amazon Personalize native
// recipes.
type HPOConfig struct {
	_ struct{} `type:"structure"`

	// The hyperparameters and their allowable ranges.
	AlgorithmHyperParameterRanges *HyperParameterRanges `locationName:"algorithmHyperParameterRanges" type:"structure"`

	// The metric to optimize during HPO.
	HpoObjective *HPOObjective `locationName:"hpoObjective" type:"structure"`

	// Describes the resource configuration for HPO.
	HpoResourceConfig *HPOResourceConfig `locationName:"hpoResourceConfig" type:"structure"`
}

// String returns the string representation
func (s HPOConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HPOConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HPOConfig"}
	if s.AlgorithmHyperParameterRanges != nil {
		if err := s.AlgorithmHyperParameterRanges.Validate(); err != nil {
			invalidParams.AddNested("AlgorithmHyperParameterRanges", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The metric to optimize during hyperparameter optimization (HPO).
type HPOObjective struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	MetricName *string `locationName:"metricName" type:"string"`

	// A regular expression for finding the metric in the training job logs.
	MetricRegex *string `locationName:"metricRegex" type:"string"`

	// The type of the metric. Valid values are Maximize and Minimize.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s HPOObjective) String() string {
	return awsutil.Prettify(s)
}

// Describes the resource configuration for hyperparameter optimization (HPO).
type HPOResourceConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of training jobs when you create a solution version. The
	// maximum value for maxNumberOfTrainingJobs is 40.
	MaxNumberOfTrainingJobs *string `locationName:"maxNumberOfTrainingJobs" type:"string"`

	// The maximum number of parallel training jobs when you create a solution version.
	// The maximum value for maxParallelTrainingJobs is 10.
	MaxParallelTrainingJobs *string `locationName:"maxParallelTrainingJobs" type:"string"`
}

// String returns the string representation
func (s HPOResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Specifies the hyperparameters and their ranges. Hyperparameters can be categorical,
// continuous, or integer-valued.
type HyperParameterRanges struct {
	_ struct{} `type:"structure"`

	// The categorical hyperparameters and their ranges.
	CategoricalHyperParameterRanges []CategoricalHyperParameterRange `locationName:"categoricalHyperParameterRanges" type:"list"`

	// The continuous hyperparameters and their ranges.
	ContinuousHyperParameterRanges []ContinuousHyperParameterRange `locationName:"continuousHyperParameterRanges" type:"list"`

	// The integer-valued hyperparameters and their ranges.
	IntegerHyperParameterRanges []IntegerHyperParameterRange `locationName:"integerHyperParameterRanges" type:"list"`
}

// String returns the string representation
func (s HyperParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterRanges) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterRanges"}
	if s.ContinuousHyperParameterRanges != nil {
		for i, v := range s.ContinuousHyperParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContinuousHyperParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.IntegerHyperParameterRanges != nil {
		for i, v := range s.IntegerHyperParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IntegerHyperParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the name and range of an integer-valued hyperparameter.
type IntegerHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *int64 `locationName:"maxValue" type:"integer"`

	// The minimum allowable value for the hyperparameter.
	MinValue *int64 `locationName:"minValue" type:"integer"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s IntegerHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerHyperParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IntegerHyperParameterRange"}
	if s.MinValue != nil && *s.MinValue < -1e+06 {
		invalidParams.Add(aws.NewErrParamMinValue("MinValue", -1e+06))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about a recipe. Each recipe provides an algorithm that
// Amazon Personalize uses in model training when you use the CreateSolution
// operation.
type Recipe struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses
	// to train the model.
	AlgorithmArn *string `locationName:"algorithmArn" type:"string"`

	// The date and time (in Unix format) that the recipe was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the recipe.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the FeatureTransformation object.
	FeatureTransformationArn *string `locationName:"featureTransformationArn" type:"string"`

	// The date and time (in Unix format) that the recipe was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the recipe.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the recipe.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// One of the following values:
	//
	//    * PERSONALIZED_RANKING
	//
	//    * RELATED_ITEMS
	//
	//    * USER_PERSONALIZATION
	RecipeType *string `locationName:"recipeType" type:"string"`

	// The status of the recipe.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s Recipe) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the properties of a recipe. For a complete listing,
// call the DescribeRecipe API.
type RecipeSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the recipe was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The date and time (in Unix time) that the recipe was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the recipe.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the recipe.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The status of the recipe.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s RecipeSummary) String() string {
	return awsutil.Prettify(s)
}

// The configuration details of an Amazon S3 input or output bucket.
type S3DataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Key Management Service (KMS)
	// key that Amazon Personalize uses to encrypt or decrypt the input and output
	// files of a batch inference job.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The file path of the Amazon S3 bucket.
	//
	// Path is a required field
	Path *string `locationName:"path" type:"string" required:"true"`
}

// String returns the string representation
func (s S3DataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3DataConfig"}

	if s.Path == nil {
		invalidParams.Add(aws.NewErrParamRequired("Path"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object that provides information about a solution. A solution is a trained
// model that can be deployed as a campaign.
type Solution struct {
	_ struct{} `type:"structure"`

	// When performAutoML is true, specifies the best recipe found.
	AutoMLResult *AutoMLResult `locationName:"autoMLResult" type:"structure"`

	// The creation date and time (in Unix time) of the solution.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that provides the training
	// data.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The event type (for example, 'click' or 'like') that is used for training
	// the model.
	EventType *string `locationName:"eventType" type:"string"`

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Describes the latest version of the solution, including the status and the
	// ARN.
	LatestSolutionVersion *SolutionVersionSummary `locationName:"latestSolutionVersion" type:"structure"`

	// The name of the solution.
	Name *string `locationName:"name" min:"1" type:"string"`

	// When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION
	// recipe from the list specified in the solution configuration (recipeArn must
	// not be specified). When false (the default), Amazon Personalize uses recipeArn
	// for training.
	PerformAutoML *bool `locationName:"performAutoML" type:"boolean"`

	// Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
	// The default is false.
	PerformHPO *bool `locationName:"performHPO" type:"boolean"`

	// The ARN of the recipe used to create the solution.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The ARN of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`

	// Describes the configuration properties for the solution.
	SolutionConfig *SolutionConfig `locationName:"solutionConfig" type:"structure"`

	// The status of the solution.
	//
	// A solution can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s Solution) String() string {
	return awsutil.Prettify(s)
}

// Describes the configuration properties for the solution.
type SolutionConfig struct {
	_ struct{} `type:"structure"`

	// Lists the hyperparameter names and ranges.
	AlgorithmHyperParameters map[string]string `locationName:"algorithmHyperParameters" type:"map"`

	// The AutoMLConfig object containing a list of recipes to search when AutoML
	// is performed.
	AutoMLConfig *AutoMLConfig `locationName:"autoMLConfig" type:"structure"`

	// Only events with a value greater than or equal to this threshold are used
	// for training a model.
	EventValueThreshold *string `locationName:"eventValueThreshold" type:"string"`

	// Lists the feature transformation parameters.
	FeatureTransformationParameters map[string]string `locationName:"featureTransformationParameters" type:"map"`

	// Describes the properties for hyperparameter optimization (HPO).
	HpoConfig *HPOConfig `locationName:"hpoConfig" type:"structure"`
}

// String returns the string representation
func (s SolutionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SolutionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SolutionConfig"}
	if s.HpoConfig != nil {
		if err := s.HpoConfig.Validate(); err != nil {
			invalidParams.AddNested("HpoConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a summary of the properties of a solution. For a complete listing,
// call the DescribeSolution API.
type SolutionSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the solution was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the solution.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`

	// The status of the solution.
	//
	// A solution can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s SolutionSummary) String() string {
	return awsutil.Prettify(s)
}

// An object that provides information about a specific version of a Solution.
type SolutionVersion struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that this version of the solution was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group providing the training
	// data.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The event type (for example, 'click' or 'like') that is used for training
	// the model.
	EventType *string `locationName:"eventType" type:"string"`

	// If training a solution version fails, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// When true, Amazon Personalize searches for the most optimal recipe according
	// to the solution configuration. When false (the default), Amazon Personalize
	// uses recipeArn.
	PerformAutoML *bool `locationName:"performAutoML" type:"boolean"`

	// Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
	// The default is false.
	PerformHPO *bool `locationName:"performHPO" type:"boolean"`

	// The ARN of the recipe used in the solution.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The ARN of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`

	// Describes the configuration properties for the solution.
	SolutionConfig *SolutionConfig `locationName:"solutionConfig" type:"structure"`

	// The ARN of the solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the solution version.
	//
	// A solution version can be in one of the following states:
	//
	//    * CREATE PENDING
	//
	//    * CREATE IN_PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	Status *string `locationName:"status" type:"string"`

	// The time used to train the model. You are billed for the time it takes to
	// train a model. This field is visible only after Amazon Personalize successfully
	// trains a model.
	TrainingHours *float64 `locationName:"trainingHours" type:"double"`

	// The scope of training used to create the solution version. The FULL option
	// trains the solution version based on the entirety of the input solution's
	// training data, while the UPDATE option processes only the training data that
	// has changed since the creation of the last solution version. Choose UPDATE
	// when you want to start recommending items added to the dataset without retraining
	// the model.
	//
	// The UPDATE option can only be used after you've created a solution version
	// with the FULL option and the training solution uses the native-recipe-hrnn-coldstart.
	TrainingMode TrainingMode `locationName:"trainingMode" type:"string" enum:"true"`

	// If hyperparameter optimization was performed, contains the hyperparameter
	// values of the best performing model.
	TunedHPOParams *TunedHPOParams `locationName:"tunedHPOParams" type:"structure"`
}

// String returns the string representation
func (s SolutionVersion) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the properties of a solution version. For a complete
// listing, call the DescribeSolutionVersion API.
type SolutionVersionSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that this version of a solution was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a solution version fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the solution version was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the solution version.
	//
	// A solution version can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s SolutionVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// If hyperparameter optimization (HPO) was performed, contains the hyperparameter
// values of the best performing model.
type TunedHPOParams struct {
	_ struct{} `type:"structure"`

	// A list of the hyperparameter values of the best performing model.
	AlgorithmHyperParameters map[string]string `locationName:"algorithmHyperParameters" type:"map"`
}

// String returns the string representation
func (s TunedHPOParams) String() string {
	return awsutil.Prettify(s)
}
