// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package personalizeiface provides an interface to enable mocking the Amazon Personalize service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package personalizeiface

import (
	"github.com/aws/aws-sdk-go-v2/service/personalize"
)

// ClientAPI provides an interface to enable mocking the
// personalize.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Personalize.
//    func myFunc(svc personalizeiface.ClientAPI) bool {
//        // Make svc.CreateBatchInferenceJob request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := personalize.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        personalizeiface.ClientPI
//    }
//    func (m *mockClientClient) CreateBatchInferenceJob(input *personalize.CreateBatchInferenceJobInput) (*personalize.CreateBatchInferenceJobOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateBatchInferenceJobRequest(*personalize.CreateBatchInferenceJobInput) personalize.CreateBatchInferenceJobRequest

	CreateCampaignRequest(*personalize.CreateCampaignInput) personalize.CreateCampaignRequest

	CreateDatasetRequest(*personalize.CreateDatasetInput) personalize.CreateDatasetRequest

	CreateDatasetGroupRequest(*personalize.CreateDatasetGroupInput) personalize.CreateDatasetGroupRequest

	CreateDatasetImportJobRequest(*personalize.CreateDatasetImportJobInput) personalize.CreateDatasetImportJobRequest

	CreateEventTrackerRequest(*personalize.CreateEventTrackerInput) personalize.CreateEventTrackerRequest

	CreateFilterRequest(*personalize.CreateFilterInput) personalize.CreateFilterRequest

	CreateSchemaRequest(*personalize.CreateSchemaInput) personalize.CreateSchemaRequest

	CreateSolutionRequest(*personalize.CreateSolutionInput) personalize.CreateSolutionRequest

	CreateSolutionVersionRequest(*personalize.CreateSolutionVersionInput) personalize.CreateSolutionVersionRequest

	DeleteCampaignRequest(*personalize.DeleteCampaignInput) personalize.DeleteCampaignRequest

	DeleteDatasetRequest(*personalize.DeleteDatasetInput) personalize.DeleteDatasetRequest

	DeleteDatasetGroupRequest(*personalize.DeleteDatasetGroupInput) personalize.DeleteDatasetGroupRequest

	DeleteEventTrackerRequest(*personalize.DeleteEventTrackerInput) personalize.DeleteEventTrackerRequest

	DeleteFilterRequest(*personalize.DeleteFilterInput) personalize.DeleteFilterRequest

	DeleteSchemaRequest(*personalize.DeleteSchemaInput) personalize.DeleteSchemaRequest

	DeleteSolutionRequest(*personalize.DeleteSolutionInput) personalize.DeleteSolutionRequest

	DescribeAlgorithmRequest(*personalize.DescribeAlgorithmInput) personalize.DescribeAlgorithmRequest

	DescribeBatchInferenceJobRequest(*personalize.DescribeBatchInferenceJobInput) personalize.DescribeBatchInferenceJobRequest

	DescribeCampaignRequest(*personalize.DescribeCampaignInput) personalize.DescribeCampaignRequest

	DescribeDatasetRequest(*personalize.DescribeDatasetInput) personalize.DescribeDatasetRequest

	DescribeDatasetGroupRequest(*personalize.DescribeDatasetGroupInput) personalize.DescribeDatasetGroupRequest

	DescribeDatasetImportJobRequest(*personalize.DescribeDatasetImportJobInput) personalize.DescribeDatasetImportJobRequest

	DescribeEventTrackerRequest(*personalize.DescribeEventTrackerInput) personalize.DescribeEventTrackerRequest

	DescribeFeatureTransformationRequest(*personalize.DescribeFeatureTransformationInput) personalize.DescribeFeatureTransformationRequest

	DescribeFilterRequest(*personalize.DescribeFilterInput) personalize.DescribeFilterRequest

	DescribeRecipeRequest(*personalize.DescribeRecipeInput) personalize.DescribeRecipeRequest

	DescribeSchemaRequest(*personalize.DescribeSchemaInput) personalize.DescribeSchemaRequest

	DescribeSolutionRequest(*personalize.DescribeSolutionInput) personalize.DescribeSolutionRequest

	DescribeSolutionVersionRequest(*personalize.DescribeSolutionVersionInput) personalize.DescribeSolutionVersionRequest

	GetSolutionMetricsRequest(*personalize.GetSolutionMetricsInput) personalize.GetSolutionMetricsRequest

	ListBatchInferenceJobsRequest(*personalize.ListBatchInferenceJobsInput) personalize.ListBatchInferenceJobsRequest

	ListCampaignsRequest(*personalize.ListCampaignsInput) personalize.ListCampaignsRequest

	ListDatasetGroupsRequest(*personalize.ListDatasetGroupsInput) personalize.ListDatasetGroupsRequest

	ListDatasetImportJobsRequest(*personalize.ListDatasetImportJobsInput) personalize.ListDatasetImportJobsRequest

	ListDatasetsRequest(*personalize.ListDatasetsInput) personalize.ListDatasetsRequest

	ListEventTrackersRequest(*personalize.ListEventTrackersInput) personalize.ListEventTrackersRequest

	ListFiltersRequest(*personalize.ListFiltersInput) personalize.ListFiltersRequest

	ListRecipesRequest(*personalize.ListRecipesInput) personalize.ListRecipesRequest

	ListSchemasRequest(*personalize.ListSchemasInput) personalize.ListSchemasRequest

	ListSolutionVersionsRequest(*personalize.ListSolutionVersionsInput) personalize.ListSolutionVersionsRequest

	ListSolutionsRequest(*personalize.ListSolutionsInput) personalize.ListSolutionsRequest

	UpdateCampaignRequest(*personalize.UpdateCampaignInput) personalize.UpdateCampaignRequest
}

var _ ClientAPI = (*personalize.Client)(nil)
