// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateRecommenderConfigurationInput struct {
	_ struct{} `type:"structure" payload:"CreateRecommenderConfiguration"`

	// Specifies Amazon Pinpoint configuration settings for retrieving and processing
	// recommendation data from a recommender model.
	//
	// CreateRecommenderConfiguration is a required field
	CreateRecommenderConfiguration *CreateRecommenderConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateRecommenderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRecommenderConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRecommenderConfigurationInput"}

	if s.CreateRecommenderConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("CreateRecommenderConfiguration"))
	}
	if s.CreateRecommenderConfiguration != nil {
		if err := s.CreateRecommenderConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CreateRecommenderConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateRecommenderConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CreateRecommenderConfiguration != nil {
		v := s.CreateRecommenderConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CreateRecommenderConfiguration", v, metadata)
	}
	return nil
}

type CreateRecommenderConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"RecommenderConfigurationResponse"`

	// Provides information about Amazon Pinpoint configuration settings for retrieving
	// and processing data from a recommender model.
	//
	// RecommenderConfigurationResponse is a required field
	RecommenderConfigurationResponse *RecommenderConfigurationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateRecommenderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateRecommenderConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecommenderConfigurationResponse != nil {
		v := s.RecommenderConfigurationResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "RecommenderConfigurationResponse", v, metadata)
	}
	return nil
}

const opCreateRecommenderConfiguration = "CreateRecommenderConfiguration"

// CreateRecommenderConfigurationRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Creates an Amazon Pinpoint configuration for a recommender model.
//
//    // Example sending a request using CreateRecommenderConfigurationRequest.
//    req := client.CreateRecommenderConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateRecommenderConfiguration
func (c *Client) CreateRecommenderConfigurationRequest(input *CreateRecommenderConfigurationInput) CreateRecommenderConfigurationRequest {
	op := &aws.Operation{
		Name:       opCreateRecommenderConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/recommenders",
	}

	if input == nil {
		input = &CreateRecommenderConfigurationInput{}
	}

	req := c.newRequest(op, input, &CreateRecommenderConfigurationOutput{})

	return CreateRecommenderConfigurationRequest{Request: req, Input: input, Copy: c.CreateRecommenderConfigurationRequest}
}

// CreateRecommenderConfigurationRequest is the request type for the
// CreateRecommenderConfiguration API operation.
type CreateRecommenderConfigurationRequest struct {
	*aws.Request
	Input *CreateRecommenderConfigurationInput
	Copy  func(*CreateRecommenderConfigurationInput) CreateRecommenderConfigurationRequest
}

// Send marshals and sends the CreateRecommenderConfiguration API request.
func (r CreateRecommenderConfigurationRequest) Send(ctx context.Context) (*CreateRecommenderConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateRecommenderConfigurationResponse{
		CreateRecommenderConfigurationOutput: r.Request.Data.(*CreateRecommenderConfigurationOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateRecommenderConfigurationResponse is the response type for the
// CreateRecommenderConfiguration API operation.
type CreateRecommenderConfigurationResponse struct {
	*CreateRecommenderConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateRecommenderConfiguration request.
func (r *CreateRecommenderConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
