// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteApnsChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApnsChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) channel for an application.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApnsChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.APNSChannelResponse != nil {
		v := s.APNSChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "APNSChannelResponse", v, metadata)
	}
	return nil
}

const opDeleteApnsChannel = "DeleteApnsChannel"

// DeleteApnsChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Disables the APNs channel for an application and deletes any existing settings
// for the channel.
//
//    // Example sending a request using DeleteApnsChannelRequest.
//    req := client.DeleteApnsChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel
func (c *Client) DeleteApnsChannelRequest(input *DeleteApnsChannelInput) DeleteApnsChannelRequest {
	op := &aws.Operation{
		Name:       opDeleteApnsChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &DeleteApnsChannelInput{}
	}

	req := c.newRequest(op, input, &DeleteApnsChannelOutput{})

	return DeleteApnsChannelRequest{Request: req, Input: input, Copy: c.DeleteApnsChannelRequest}
}

// DeleteApnsChannelRequest is the request type for the
// DeleteApnsChannel API operation.
type DeleteApnsChannelRequest struct {
	*aws.Request
	Input *DeleteApnsChannelInput
	Copy  func(*DeleteApnsChannelInput) DeleteApnsChannelRequest
}

// Send marshals and sends the DeleteApnsChannel API request.
func (r DeleteApnsChannelRequest) Send(ctx context.Context) (*DeleteApnsChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteApnsChannelResponse{
		DeleteApnsChannelOutput: r.Request.Data.(*DeleteApnsChannelOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteApnsChannelResponse is the response type for the
// DeleteApnsChannel API operation.
type DeleteApnsChannelResponse struct {
	*DeleteApnsChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApnsChannel request.
func (r *DeleteApnsChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
