// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteSmsTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s DeleteSmsTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSmsTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSmsTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSmsTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "template-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteSmsTemplateOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSmsTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSmsTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageBody != nil {
		v := s.MessageBody

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "MessageBody", v, metadata)
	}
	return nil
}

const opDeleteSmsTemplate = "DeleteSmsTemplate"

// DeleteSmsTemplateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Deletes a message template for messages that were sent through the SMS channel.
//
//    // Example sending a request using DeleteSmsTemplateRequest.
//    req := client.DeleteSmsTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsTemplate
func (c *Client) DeleteSmsTemplateRequest(input *DeleteSmsTemplateInput) DeleteSmsTemplateRequest {
	op := &aws.Operation{
		Name:       opDeleteSmsTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/templates/{template-name}/sms",
	}

	if input == nil {
		input = &DeleteSmsTemplateInput{}
	}

	req := c.newRequest(op, input, &DeleteSmsTemplateOutput{})

	return DeleteSmsTemplateRequest{Request: req, Input: input, Copy: c.DeleteSmsTemplateRequest}
}

// DeleteSmsTemplateRequest is the request type for the
// DeleteSmsTemplate API operation.
type DeleteSmsTemplateRequest struct {
	*aws.Request
	Input *DeleteSmsTemplateInput
	Copy  func(*DeleteSmsTemplateInput) DeleteSmsTemplateRequest
}

// Send marshals and sends the DeleteSmsTemplate API request.
func (r DeleteSmsTemplateRequest) Send(ctx context.Context) (*DeleteSmsTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSmsTemplateResponse{
		DeleteSmsTemplateOutput: r.Request.Data.(*DeleteSmsTemplateOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSmsTemplateResponse is the response type for the
// DeleteSmsTemplate API operation.
type DeleteSmsTemplateResponse struct {
	*DeleteSmsTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSmsTemplate request.
func (r *DeleteSmsTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
