// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s GetEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEmailTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetEmailTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetEmailTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "template-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetEmailTemplateOutput struct {
	_ struct{} `type:"structure" payload:"EmailTemplateResponse"`

	// Provides information about the content and settings for a message template
	// that can be used in messages that are sent through the email channel.
	//
	// EmailTemplateResponse is a required field
	EmailTemplateResponse *EmailTemplateResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetEmailTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EmailTemplateResponse != nil {
		v := s.EmailTemplateResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "EmailTemplateResponse", v, metadata)
	}
	return nil
}

const opGetEmailTemplate = "GetEmailTemplate"

// GetEmailTemplateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves the content and settings of a message template for messages that
// are sent through the email channel.
//
//    // Example sending a request using GetEmailTemplateRequest.
//    req := client.GetEmailTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailTemplate
func (c *Client) GetEmailTemplateRequest(input *GetEmailTemplateInput) GetEmailTemplateRequest {
	op := &aws.Operation{
		Name:       opGetEmailTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/templates/{template-name}/email",
	}

	if input == nil {
		input = &GetEmailTemplateInput{}
	}

	req := c.newRequest(op, input, &GetEmailTemplateOutput{})

	return GetEmailTemplateRequest{Request: req, Input: input, Copy: c.GetEmailTemplateRequest}
}

// GetEmailTemplateRequest is the request type for the
// GetEmailTemplate API operation.
type GetEmailTemplateRequest struct {
	*aws.Request
	Input *GetEmailTemplateInput
	Copy  func(*GetEmailTemplateInput) GetEmailTemplateRequest
}

// Send marshals and sends the GetEmailTemplate API request.
func (r GetEmailTemplateRequest) Send(ctx context.Context) (*GetEmailTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEmailTemplateResponse{
		GetEmailTemplateOutput: r.Request.Data.(*GetEmailTemplateOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetEmailTemplateResponse is the response type for the
// GetEmailTemplate API operation.
type GetEmailTemplateResponse struct {
	*GetEmailTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEmailTemplate request.
func (r *GetEmailTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
