// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetJourneyDateRangeKpiInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	EndTime *time.Time `location:"querystring" locationName:"end-time" type:"timestamp" timestampFormat:"iso8601"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`

	// KpiName is a required field
	KpiName *string `location:"uri" locationName:"kpi-name" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	StartTime *time.Time `location:"querystring" locationName:"start-time" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetJourneyDateRangeKpiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJourneyDateRangeKpiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetJourneyDateRangeKpiInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.JourneyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JourneyId"))
	}

	if s.KpiName == nil {
		invalidParams.Add(aws.NewErrParamRequired("KpiName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetJourneyDateRangeKpiInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyId != nil {
		v := *s.JourneyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "journey-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KpiName != nil {
		v := *s.KpiName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "kpi-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "end-time",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "page-size", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "start-time",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	return nil
}

type GetJourneyDateRangeKpiOutput struct {
	_ struct{} `type:"structure" payload:"JourneyDateRangeKpiResponse"`

	// Provides the results of a query that retrieved the data for a standard engagement
	// metric that applies to a journey, and provides information about that query.
	//
	// JourneyDateRangeKpiResponse is a required field
	JourneyDateRangeKpiResponse *JourneyDateRangeKpiResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetJourneyDateRangeKpiOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetJourneyDateRangeKpiOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.JourneyDateRangeKpiResponse != nil {
		v := s.JourneyDateRangeKpiResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "JourneyDateRangeKpiResponse", v, metadata)
	}
	return nil
}

const opGetJourneyDateRangeKpi = "GetJourneyDateRangeKpi"

// GetJourneyDateRangeKpiRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard engagement metric
// that applies to a journey.
//
//    // Example sending a request using GetJourneyDateRangeKpiRequest.
//    req := client.GetJourneyDateRangeKpiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyDateRangeKpi
func (c *Client) GetJourneyDateRangeKpiRequest(input *GetJourneyDateRangeKpiInput) GetJourneyDateRangeKpiRequest {
	op := &aws.Operation{
		Name:       opGetJourneyDateRangeKpi,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}/kpis/daterange/{kpi-name}",
	}

	if input == nil {
		input = &GetJourneyDateRangeKpiInput{}
	}

	req := c.newRequest(op, input, &GetJourneyDateRangeKpiOutput{})

	return GetJourneyDateRangeKpiRequest{Request: req, Input: input, Copy: c.GetJourneyDateRangeKpiRequest}
}

// GetJourneyDateRangeKpiRequest is the request type for the
// GetJourneyDateRangeKpi API operation.
type GetJourneyDateRangeKpiRequest struct {
	*aws.Request
	Input *GetJourneyDateRangeKpiInput
	Copy  func(*GetJourneyDateRangeKpiInput) GetJourneyDateRangeKpiRequest
}

// Send marshals and sends the GetJourneyDateRangeKpi API request.
func (r GetJourneyDateRangeKpiRequest) Send(ctx context.Context) (*GetJourneyDateRangeKpiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetJourneyDateRangeKpiResponse{
		GetJourneyDateRangeKpiOutput: r.Request.Data.(*GetJourneyDateRangeKpiOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetJourneyDateRangeKpiResponse is the response type for the
// GetJourneyDateRangeKpi API operation.
type GetJourneyDateRangeKpiResponse struct {
	*GetJourneyDateRangeKpiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetJourneyDateRangeKpi request.
func (r *GetJourneyDateRangeKpiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
