// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetRecommenderConfigurationsInput struct {
	_ struct{} `type:"structure"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetRecommenderConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRecommenderConfigurationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "page-size", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Token != nil {
		v := *s.Token

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetRecommenderConfigurationsOutput struct {
	_ struct{} `type:"structure" payload:"ListRecommenderConfigurationsResponse"`

	// Provides information about all the recommender model configurations that
	// are associated with your Amazon Pinpoint account.
	//
	// ListRecommenderConfigurationsResponse is a required field
	ListRecommenderConfigurationsResponse *ListRecommenderConfigurationsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetRecommenderConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRecommenderConfigurationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ListRecommenderConfigurationsResponse != nil {
		v := s.ListRecommenderConfigurationsResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ListRecommenderConfigurationsResponse", v, metadata)
	}
	return nil
}

const opGetRecommenderConfigurations = "GetRecommenderConfigurations"

// GetRecommenderConfigurationsRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about all the recommender model configurations that
// are associated with your Amazon Pinpoint account.
//
//    // Example sending a request using GetRecommenderConfigurationsRequest.
//    req := client.GetRecommenderConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfigurations
func (c *Client) GetRecommenderConfigurationsRequest(input *GetRecommenderConfigurationsInput) GetRecommenderConfigurationsRequest {
	op := &aws.Operation{
		Name:       opGetRecommenderConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/recommenders",
	}

	if input == nil {
		input = &GetRecommenderConfigurationsInput{}
	}

	req := c.newRequest(op, input, &GetRecommenderConfigurationsOutput{})

	return GetRecommenderConfigurationsRequest{Request: req, Input: input, Copy: c.GetRecommenderConfigurationsRequest}
}

// GetRecommenderConfigurationsRequest is the request type for the
// GetRecommenderConfigurations API operation.
type GetRecommenderConfigurationsRequest struct {
	*aws.Request
	Input *GetRecommenderConfigurationsInput
	Copy  func(*GetRecommenderConfigurationsInput) GetRecommenderConfigurationsRequest
}

// Send marshals and sends the GetRecommenderConfigurations API request.
func (r GetRecommenderConfigurationsRequest) Send(ctx context.Context) (*GetRecommenderConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRecommenderConfigurationsResponse{
		GetRecommenderConfigurationsOutput: r.Request.Data.(*GetRecommenderConfigurationsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRecommenderConfigurationsResponse is the response type for the
// GetRecommenderConfigurations API operation.
type GetRecommenderConfigurationsResponse struct {
	*GetRecommenderConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRecommenderConfigurations request.
func (r *GetRecommenderConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
