// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetVoiceTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s GetVoiceTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetVoiceTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "template-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetVoiceTemplateOutput struct {
	_ struct{} `type:"structure" payload:"VoiceTemplateResponse"`

	// Provides information about the content and settings for a message template
	// that can be used in messages that are sent through the voice channel.
	//
	// VoiceTemplateResponse is a required field
	VoiceTemplateResponse *VoiceTemplateResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetVoiceTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VoiceTemplateResponse != nil {
		v := s.VoiceTemplateResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "VoiceTemplateResponse", v, metadata)
	}
	return nil
}

const opGetVoiceTemplate = "GetVoiceTemplate"

// GetVoiceTemplateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves the content and settings of a message template for messages that
// are sent through the voice channel.
//
//    // Example sending a request using GetVoiceTemplateRequest.
//    req := client.GetVoiceTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceTemplate
func (c *Client) GetVoiceTemplateRequest(input *GetVoiceTemplateInput) GetVoiceTemplateRequest {
	op := &aws.Operation{
		Name:       opGetVoiceTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/templates/{template-name}/voice",
	}

	if input == nil {
		input = &GetVoiceTemplateInput{}
	}

	req := c.newRequest(op, input, &GetVoiceTemplateOutput{})

	return GetVoiceTemplateRequest{Request: req, Input: input, Copy: c.GetVoiceTemplateRequest}
}

// GetVoiceTemplateRequest is the request type for the
// GetVoiceTemplate API operation.
type GetVoiceTemplateRequest struct {
	*aws.Request
	Input *GetVoiceTemplateInput
	Copy  func(*GetVoiceTemplateInput) GetVoiceTemplateRequest
}

// Send marshals and sends the GetVoiceTemplate API request.
func (r GetVoiceTemplateRequest) Send(ctx context.Context) (*GetVoiceTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVoiceTemplateResponse{
		GetVoiceTemplateOutput: r.Request.Data.(*GetVoiceTemplateOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetVoiceTemplateResponse is the response type for the
// GetVoiceTemplate API operation.
type GetVoiceTemplateResponse struct {
	*GetVoiceTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVoiceTemplate request.
func (r *GetVoiceTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
