// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateCampaignInput struct {
	_ struct{} `type:"structure" payload:"WriteCampaignRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	// Specifies the configuration and other settings for a campaign.
	//
	// WriteCampaignRequest is a required field
	WriteCampaignRequest *WriteCampaignRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateCampaignInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.CampaignId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CampaignId"))
	}

	if s.WriteCampaignRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("WriteCampaignRequest"))
	}
	if s.WriteCampaignRequest != nil {
		if err := s.WriteCampaignRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteCampaignRequest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateCampaignInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CampaignId != nil {
		v := *s.CampaignId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "campaign-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WriteCampaignRequest != nil {
		v := s.WriteCampaignRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "WriteCampaignRequest", v, metadata)
	}
	return nil
}

type UpdateCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateCampaignOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CampaignResponse != nil {
		v := s.CampaignResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CampaignResponse", v, metadata)
	}
	return nil
}

const opUpdateCampaign = "UpdateCampaign"

// UpdateCampaignRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Updates the configuration and other settings for a campaign.
//
//    // Example sending a request using UpdateCampaignRequest.
//    req := client.UpdateCampaignRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign
func (c *Client) UpdateCampaignRequest(input *UpdateCampaignInput) UpdateCampaignRequest {
	op := &aws.Operation{
		Name:       opUpdateCampaign,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &UpdateCampaignInput{}
	}

	req := c.newRequest(op, input, &UpdateCampaignOutput{})

	return UpdateCampaignRequest{Request: req, Input: input, Copy: c.UpdateCampaignRequest}
}

// UpdateCampaignRequest is the request type for the
// UpdateCampaign API operation.
type UpdateCampaignRequest struct {
	*aws.Request
	Input *UpdateCampaignInput
	Copy  func(*UpdateCampaignInput) UpdateCampaignRequest
}

// Send marshals and sends the UpdateCampaign API request.
func (r UpdateCampaignRequest) Send(ctx context.Context) (*UpdateCampaignResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateCampaignResponse{
		UpdateCampaignOutput: r.Request.Data.(*UpdateCampaignOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateCampaignResponse is the response type for the
// UpdateCampaign API operation.
type UpdateCampaignResponse struct {
	*UpdateCampaignOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateCampaign request.
func (r *UpdateCampaignResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
