// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateEmailTemplateInput struct {
	_ struct{} `type:"structure" payload:"EmailTemplateRequest"`

	CreateNewVersion *bool `location:"querystring" locationName:"create-new-version" type:"boolean"`

	// Specifies the content and settings for a message template that can be used
	// in messages that are sent through the email channel.
	//
	// EmailTemplateRequest is a required field
	EmailTemplateRequest *EmailTemplateRequest `type:"structure" required:"true"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s UpdateEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEmailTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEmailTemplateInput"}

	if s.EmailTemplateRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("EmailTemplateRequest"))
	}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEmailTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "template-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EmailTemplateRequest != nil {
		v := s.EmailTemplateRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "EmailTemplateRequest", v, metadata)
	}
	if s.CreateNewVersion != nil {
		v := *s.CreateNewVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "create-new-version", protocol.BoolValue(v), metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateEmailTemplateOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEmailTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageBody != nil {
		v := s.MessageBody

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "MessageBody", v, metadata)
	}
	return nil
}

const opUpdateEmailTemplate = "UpdateEmailTemplate"

// UpdateEmailTemplateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Updates an existing message template for messages that are sent through the
// email channel.
//
//    // Example sending a request using UpdateEmailTemplateRequest.
//    req := client.UpdateEmailTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailTemplate
func (c *Client) UpdateEmailTemplateRequest(input *UpdateEmailTemplateInput) UpdateEmailTemplateRequest {
	op := &aws.Operation{
		Name:       opUpdateEmailTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/templates/{template-name}/email",
	}

	if input == nil {
		input = &UpdateEmailTemplateInput{}
	}

	req := c.newRequest(op, input, &UpdateEmailTemplateOutput{})

	return UpdateEmailTemplateRequest{Request: req, Input: input, Copy: c.UpdateEmailTemplateRequest}
}

// UpdateEmailTemplateRequest is the request type for the
// UpdateEmailTemplate API operation.
type UpdateEmailTemplateRequest struct {
	*aws.Request
	Input *UpdateEmailTemplateInput
	Copy  func(*UpdateEmailTemplateInput) UpdateEmailTemplateRequest
}

// Send marshals and sends the UpdateEmailTemplate API request.
func (r UpdateEmailTemplateRequest) Send(ctx context.Context) (*UpdateEmailTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEmailTemplateResponse{
		UpdateEmailTemplateOutput: r.Request.Data.(*UpdateEmailTemplateOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEmailTemplateResponse is the response type for the
// UpdateEmailTemplate API operation.
type UpdateEmailTemplateResponse struct {
	*UpdateEmailTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEmailTemplate request.
func (r *UpdateEmailTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
