// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateJourneyInput struct {
	_ struct{} `type:"structure" payload:"WriteJourneyRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`

	// Specifies the configuration and other settings for a journey.
	//
	// WriteJourneyRequest is a required field
	WriteJourneyRequest *WriteJourneyRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateJourneyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJourneyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateJourneyInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.JourneyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JourneyId"))
	}

	if s.WriteJourneyRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("WriteJourneyRequest"))
	}
	if s.WriteJourneyRequest != nil {
		if err := s.WriteJourneyRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteJourneyRequest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateJourneyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyId != nil {
		v := *s.JourneyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "journey-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WriteJourneyRequest != nil {
		v := s.WriteJourneyRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "WriteJourneyRequest", v, metadata)
	}
	return nil
}

type UpdateJourneyOutput struct {
	_ struct{} `type:"structure" payload:"JourneyResponse"`

	// Provides information about the status, configuration, and other settings
	// for a journey.
	//
	// JourneyResponse is a required field
	JourneyResponse *JourneyResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateJourneyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateJourneyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.JourneyResponse != nil {
		v := s.JourneyResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "JourneyResponse", v, metadata)
	}
	return nil
}

const opUpdateJourney = "UpdateJourney"

// UpdateJourneyRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Updates the configuration and other settings for a journey.
//
//    // Example sending a request using UpdateJourneyRequest.
//    req := client.UpdateJourneyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourney
func (c *Client) UpdateJourneyRequest(input *UpdateJourneyInput) UpdateJourneyRequest {
	op := &aws.Operation{
		Name:       opUpdateJourney,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}",
	}

	if input == nil {
		input = &UpdateJourneyInput{}
	}

	req := c.newRequest(op, input, &UpdateJourneyOutput{})

	return UpdateJourneyRequest{Request: req, Input: input, Copy: c.UpdateJourneyRequest}
}

// UpdateJourneyRequest is the request type for the
// UpdateJourney API operation.
type UpdateJourneyRequest struct {
	*aws.Request
	Input *UpdateJourneyInput
	Copy  func(*UpdateJourneyInput) UpdateJourneyRequest
}

// Send marshals and sends the UpdateJourney API request.
func (r UpdateJourneyRequest) Send(ctx context.Context) (*UpdateJourneyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateJourneyResponse{
		UpdateJourneyOutput: r.Request.Data.(*UpdateJourneyOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateJourneyResponse is the response type for the
// UpdateJourney API operation.
type UpdateJourneyResponse struct {
	*UpdateJourneyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateJourney request.
func (r *UpdateJourneyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
