// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CancelJournalKinesisStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The unique ID that QLDB assigns to each QLDB journal stream.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"22" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelJournalKinesisStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJournalKinesisStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelJournalKinesisStreamInput"}

	if s.LedgerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LedgerName"))
	}
	if s.LedgerName != nil && len(*s.LedgerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LedgerName", 1))
	}

	if s.StreamId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 22 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CancelJournalKinesisStreamInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.LedgerName != nil {
		v := *s.LedgerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CancelJournalKinesisStreamOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID that QLDB assigns to each QLDB journal stream.
	StreamId *string `min:"22" type:"string"`
}

// String returns the string representation
func (s CancelJournalKinesisStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CancelJournalKinesisStreamOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCancelJournalKinesisStream = "CancelJournalKinesisStream"

// CancelJournalKinesisStreamRequest returns a request value for making API operation for
// Amazon QLDB.
//
// Ends a given Amazon QLDB journal stream. Before a stream can be canceled,
// its current status must be ACTIVE.
//
// You can't restart a stream after you cancel it. Canceled QLDB stream resources
// are subject to a 7-day retention period, so they are automatically deleted
// after this limit expires.
//
//    // Example sending a request using CancelJournalKinesisStreamRequest.
//    req := client.CancelJournalKinesisStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CancelJournalKinesisStream
func (c *Client) CancelJournalKinesisStreamRequest(input *CancelJournalKinesisStreamInput) CancelJournalKinesisStreamRequest {
	op := &aws.Operation{
		Name:       opCancelJournalKinesisStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/ledgers/{name}/journal-kinesis-streams/{streamId}",
	}

	if input == nil {
		input = &CancelJournalKinesisStreamInput{}
	}

	req := c.newRequest(op, input, &CancelJournalKinesisStreamOutput{})

	return CancelJournalKinesisStreamRequest{Request: req, Input: input, Copy: c.CancelJournalKinesisStreamRequest}
}

// CancelJournalKinesisStreamRequest is the request type for the
// CancelJournalKinesisStream API operation.
type CancelJournalKinesisStreamRequest struct {
	*aws.Request
	Input *CancelJournalKinesisStreamInput
	Copy  func(*CancelJournalKinesisStreamInput) CancelJournalKinesisStreamRequest
}

// Send marshals and sends the CancelJournalKinesisStream API request.
func (r CancelJournalKinesisStreamRequest) Send(ctx context.Context) (*CancelJournalKinesisStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelJournalKinesisStreamResponse{
		CancelJournalKinesisStreamOutput: r.Request.Data.(*CancelJournalKinesisStreamOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelJournalKinesisStreamResponse is the response type for the
// CancelJournalKinesisStream API operation.
type CancelJournalKinesisStreamResponse struct {
	*CancelJournalKinesisStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelJournalKinesisStream request.
func (r *CancelJournalKinesisStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
