// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeJournalKinesisStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The unique ID that QLDB assigns to each QLDB journal stream.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"22" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeJournalKinesisStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJournalKinesisStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeJournalKinesisStreamInput"}

	if s.LedgerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LedgerName"))
	}
	if s.LedgerName != nil && len(*s.LedgerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LedgerName", 1))
	}

	if s.StreamId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 22 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeJournalKinesisStreamInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.LedgerName != nil {
		v := *s.LedgerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeJournalKinesisStreamOutput struct {
	_ struct{} `type:"structure"`

	// Information about the QLDB journal stream returned by a DescribeJournalS3Export
	// request.
	Stream *JournalKinesisStreamDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeJournalKinesisStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeJournalKinesisStreamOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Stream != nil {
		v := s.Stream

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Stream", v, metadata)
	}
	return nil
}

const opDescribeJournalKinesisStream = "DescribeJournalKinesisStream"

// DescribeJournalKinesisStreamRequest returns a request value for making API operation for
// Amazon QLDB.
//
// Returns detailed information about a given Amazon QLDB journal stream. The
// output includes the Amazon Resource Name (ARN), stream name, current status,
// creation time, and the parameters of your original stream creation request.
//
//    // Example sending a request using DescribeJournalKinesisStreamRequest.
//    req := client.DescribeJournalKinesisStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeJournalKinesisStream
func (c *Client) DescribeJournalKinesisStreamRequest(input *DescribeJournalKinesisStreamInput) DescribeJournalKinesisStreamRequest {
	op := &aws.Operation{
		Name:       opDescribeJournalKinesisStream,
		HTTPMethod: "GET",
		HTTPPath:   "/ledgers/{name}/journal-kinesis-streams/{streamId}",
	}

	if input == nil {
		input = &DescribeJournalKinesisStreamInput{}
	}

	req := c.newRequest(op, input, &DescribeJournalKinesisStreamOutput{})

	return DescribeJournalKinesisStreamRequest{Request: req, Input: input, Copy: c.DescribeJournalKinesisStreamRequest}
}

// DescribeJournalKinesisStreamRequest is the request type for the
// DescribeJournalKinesisStream API operation.
type DescribeJournalKinesisStreamRequest struct {
	*aws.Request
	Input *DescribeJournalKinesisStreamInput
	Copy  func(*DescribeJournalKinesisStreamInput) DescribeJournalKinesisStreamRequest
}

// Send marshals and sends the DescribeJournalKinesisStream API request.
func (r DescribeJournalKinesisStreamRequest) Send(ctx context.Context) (*DescribeJournalKinesisStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeJournalKinesisStreamResponse{
		DescribeJournalKinesisStreamOutput: r.Request.Data.(*DescribeJournalKinesisStreamOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeJournalKinesisStreamResponse is the response type for the
// DescribeJournalKinesisStream API operation.
type DescribeJournalKinesisStreamResponse struct {
	*DescribeJournalKinesisStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeJournalKinesisStream request.
func (r *DescribeJournalKinesisStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
