// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListJournalKinesisStreamsForLedgerInput struct {
	_ struct{} `type:"structure"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in a single ListJournalKinesisStreamsForLedger
	// request. (The actual number of results returned might be fewer.)
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A pagination token, indicating that you want to retrieve the next page of
	// results. If you received a value for NextToken in the response from a previous
	// ListJournalKinesisStreamsForLedger call, you should use that value as input
	// here.
	NextToken *string `location:"querystring" locationName:"next_token" min:"4" type:"string"`
}

// String returns the string representation
func (s ListJournalKinesisStreamsForLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJournalKinesisStreamsForLedgerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListJournalKinesisStreamsForLedgerInput"}

	if s.LedgerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LedgerName"))
	}
	if s.LedgerName != nil && len(*s.LedgerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LedgerName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListJournalKinesisStreamsForLedgerInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.LedgerName != nil {
		v := *s.LedgerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max_results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next_token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListJournalKinesisStreamsForLedgerOutput struct {
	_ struct{} `type:"structure"`

	//    * If NextToken is empty, the last page of results has been processed and
	//    there are no more results to be retrieved.
	//
	//    * If NextToken is not empty, more results are available. To retrieve the
	//    next page of results, use the value of NextToken in a subsequent ListJournalKinesisStreamsForLedger
	//    call.
	NextToken *string `min:"4" type:"string"`

	// The array of QLDB journal stream descriptors that are associated with the
	// given ledger.
	Streams []JournalKinesisStreamDescription `type:"list"`
}

// String returns the string representation
func (s ListJournalKinesisStreamsForLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListJournalKinesisStreamsForLedgerOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Streams != nil {
		v := s.Streams

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Streams", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListJournalKinesisStreamsForLedger = "ListJournalKinesisStreamsForLedger"

// ListJournalKinesisStreamsForLedgerRequest returns a request value for making API operation for
// Amazon QLDB.
//
// Returns an array of all Amazon QLDB journal stream descriptors for a given
// ledger. The output of each stream descriptor includes the same details that
// are returned by DescribeJournalKinesisStream.
//
// This action returns a maximum of MaxResults items. It is paginated so that
// you can retrieve all the items by calling ListJournalKinesisStreamsForLedger
// multiple times.
//
//    // Example sending a request using ListJournalKinesisStreamsForLedgerRequest.
//    req := client.ListJournalKinesisStreamsForLedgerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalKinesisStreamsForLedger
func (c *Client) ListJournalKinesisStreamsForLedgerRequest(input *ListJournalKinesisStreamsForLedgerInput) ListJournalKinesisStreamsForLedgerRequest {
	op := &aws.Operation{
		Name:       opListJournalKinesisStreamsForLedger,
		HTTPMethod: "GET",
		HTTPPath:   "/ledgers/{name}/journal-kinesis-streams",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJournalKinesisStreamsForLedgerInput{}
	}

	req := c.newRequest(op, input, &ListJournalKinesisStreamsForLedgerOutput{})

	return ListJournalKinesisStreamsForLedgerRequest{Request: req, Input: input, Copy: c.ListJournalKinesisStreamsForLedgerRequest}
}

// ListJournalKinesisStreamsForLedgerRequest is the request type for the
// ListJournalKinesisStreamsForLedger API operation.
type ListJournalKinesisStreamsForLedgerRequest struct {
	*aws.Request
	Input *ListJournalKinesisStreamsForLedgerInput
	Copy  func(*ListJournalKinesisStreamsForLedgerInput) ListJournalKinesisStreamsForLedgerRequest
}

// Send marshals and sends the ListJournalKinesisStreamsForLedger API request.
func (r ListJournalKinesisStreamsForLedgerRequest) Send(ctx context.Context) (*ListJournalKinesisStreamsForLedgerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListJournalKinesisStreamsForLedgerResponse{
		ListJournalKinesisStreamsForLedgerOutput: r.Request.Data.(*ListJournalKinesisStreamsForLedgerOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListJournalKinesisStreamsForLedgerRequestPaginator returns a paginator for ListJournalKinesisStreamsForLedger.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListJournalKinesisStreamsForLedgerRequest(input)
//   p := qldb.NewListJournalKinesisStreamsForLedgerRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListJournalKinesisStreamsForLedgerPaginator(req ListJournalKinesisStreamsForLedgerRequest) ListJournalKinesisStreamsForLedgerPaginator {
	return ListJournalKinesisStreamsForLedgerPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListJournalKinesisStreamsForLedgerInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListJournalKinesisStreamsForLedgerPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListJournalKinesisStreamsForLedgerPaginator struct {
	aws.Pager
}

func (p *ListJournalKinesisStreamsForLedgerPaginator) CurrentPage() *ListJournalKinesisStreamsForLedgerOutput {
	return p.Pager.CurrentPage().(*ListJournalKinesisStreamsForLedgerOutput)
}

// ListJournalKinesisStreamsForLedgerResponse is the response type for the
// ListJournalKinesisStreamsForLedger API operation.
type ListJournalKinesisStreamsForLedgerResponse struct {
	*ListJournalKinesisStreamsForLedgerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListJournalKinesisStreamsForLedger request.
func (r *ListJournalKinesisStreamsForLedgerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
