// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListJournalS3ExportsForLedgerInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single ListJournalS3ExportsForLedger
	// request. (The actual number of results returned might be fewer.)
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A pagination token, indicating that you want to retrieve the next page of
	// results. If you received a value for NextToken in the response from a previous
	// ListJournalS3ExportsForLedger call, then you should use that value as input
	// here.
	NextToken *string `location:"querystring" locationName:"next_token" min:"4" type:"string"`
}

// String returns the string representation
func (s ListJournalS3ExportsForLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJournalS3ExportsForLedgerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListJournalS3ExportsForLedgerInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListJournalS3ExportsForLedgerInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max_results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next_token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListJournalS3ExportsForLedgerOutput struct {
	_ struct{} `type:"structure"`

	// The array of journal export job descriptions that are associated with the
	// specified ledger.
	JournalS3Exports []JournalS3ExportDescription `type:"list"`

	//    * If NextToken is empty, then the last page of results has been processed
	//    and there are no more results to be retrieved.
	//
	//    * If NextToken is not empty, then there are more results available. To
	//    retrieve the next page of results, use the value of NextToken in a subsequent
	//    ListJournalS3ExportsForLedger call.
	NextToken *string `min:"4" type:"string"`
}

// String returns the string representation
func (s ListJournalS3ExportsForLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListJournalS3ExportsForLedgerOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.JournalS3Exports != nil {
		v := s.JournalS3Exports

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "JournalS3Exports", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListJournalS3ExportsForLedger = "ListJournalS3ExportsForLedger"

// ListJournalS3ExportsForLedgerRequest returns a request value for making API operation for
// Amazon QLDB.
//
// Returns an array of journal export job descriptions for a specified ledger.
//
// This action returns a maximum of MaxResults items, and is paginated so that
// you can retrieve all the items by calling ListJournalS3ExportsForLedger multiple
// times.
//
// This action does not return any expired export jobs. For more information,
// see Export Job Expiration (https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration)
// in the Amazon QLDB Developer Guide.
//
//    // Example sending a request using ListJournalS3ExportsForLedgerRequest.
//    req := client.ListJournalS3ExportsForLedgerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3ExportsForLedger
func (c *Client) ListJournalS3ExportsForLedgerRequest(input *ListJournalS3ExportsForLedgerInput) ListJournalS3ExportsForLedgerRequest {
	op := &aws.Operation{
		Name:       opListJournalS3ExportsForLedger,
		HTTPMethod: "GET",
		HTTPPath:   "/ledgers/{name}/journal-s3-exports",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJournalS3ExportsForLedgerInput{}
	}

	req := c.newRequest(op, input, &ListJournalS3ExportsForLedgerOutput{})

	return ListJournalS3ExportsForLedgerRequest{Request: req, Input: input, Copy: c.ListJournalS3ExportsForLedgerRequest}
}

// ListJournalS3ExportsForLedgerRequest is the request type for the
// ListJournalS3ExportsForLedger API operation.
type ListJournalS3ExportsForLedgerRequest struct {
	*aws.Request
	Input *ListJournalS3ExportsForLedgerInput
	Copy  func(*ListJournalS3ExportsForLedgerInput) ListJournalS3ExportsForLedgerRequest
}

// Send marshals and sends the ListJournalS3ExportsForLedger API request.
func (r ListJournalS3ExportsForLedgerRequest) Send(ctx context.Context) (*ListJournalS3ExportsForLedgerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListJournalS3ExportsForLedgerResponse{
		ListJournalS3ExportsForLedgerOutput: r.Request.Data.(*ListJournalS3ExportsForLedgerOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListJournalS3ExportsForLedgerRequestPaginator returns a paginator for ListJournalS3ExportsForLedger.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListJournalS3ExportsForLedgerRequest(input)
//   p := qldb.NewListJournalS3ExportsForLedgerRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListJournalS3ExportsForLedgerPaginator(req ListJournalS3ExportsForLedgerRequest) ListJournalS3ExportsForLedgerPaginator {
	return ListJournalS3ExportsForLedgerPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListJournalS3ExportsForLedgerInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListJournalS3ExportsForLedgerPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListJournalS3ExportsForLedgerPaginator struct {
	aws.Pager
}

func (p *ListJournalS3ExportsForLedgerPaginator) CurrentPage() *ListJournalS3ExportsForLedgerOutput {
	return p.Pager.CurrentPage().(*ListJournalS3ExportsForLedgerOutput)
}

// ListJournalS3ExportsForLedgerResponse is the response type for the
// ListJournalS3ExportsForLedger API operation.
type ListJournalS3ExportsForLedgerResponse struct {
	*ListJournalS3ExportsForLedgerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListJournalS3ExportsForLedger request.
func (r *ListJournalS3ExportsForLedgerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
