// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateThemeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account where you want to store the new theme.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the theme that a custom theme will inherit from. All themes inherit
	// from one of the starting themes defined by Amazon QuickSight. For a list
	// of the starting themes, use ListThemes or choose Themes from within a QuickSight
	// analysis.
	//
	// BaseThemeId is a required field
	BaseThemeId *string `min:"1" type:"string" required:"true"`

	// The theme configuration, which contains the theme display properties.
	//
	// Configuration is a required field
	Configuration *ThemeConfiguration `type:"structure" required:"true"`

	// A display name for the theme.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A valid grouping of resource permissions to apply to the new theme.
	Permissions []ResourcePermission `min:"1" type:"list"`

	// A map of the key-value pairs for the resource tag or tags that you want to
	// add to the resource.
	Tags []Tag `min:"1" type:"list"`

	// An ID for the theme that you want to create. The theme ID is unique per AWS
	// Region in each AWS account.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// A description of the first version of the theme that you're creating. Every
	// time UpdateTheme is called, a new version is created. Each version of the
	// theme has a description of the version in the VersionDescription field.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThemeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThemeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateThemeInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.BaseThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BaseThemeId"))
	}
	if s.BaseThemeId != nil && len(*s.BaseThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BaseThemeId", 1))
	}

	if s.Configuration == nil {
		invalidParams.Add(aws.NewErrParamRequired("Configuration"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if s.ThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThemeId", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateThemeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BaseThemeId != nil {
		v := *s.BaseThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BaseThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Configuration != nil {
		v := s.Configuration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Configuration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Permissions != nil {
		v := s.Permissions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Permissions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VersionDescription != nil {
		v := *s.VersionDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateThemeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the theme.
	Arn *string `type:"string"`

	// The theme creation status.
	CreationStatus ResourceStatus `type:"string" enum:"true"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ID of the theme.
	ThemeId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the new theme.
	VersionArn *string `type:"string"`
}

// String returns the string representation
func (s CreateThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateThemeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CreationStatus) > 0 {
		v := s.CreationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionArn != nil {
		v := *s.VersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opCreateTheme = "CreateTheme"

// CreateThemeRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Creates a theme.
//
// A theme is set of configuration options for color and layout. Themes apply
// to analyses and dashboards. For more information, see Using Themes in Amazon
// QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html)
// in the Amazon QuickSight User Guide.
//
//    // Example sending a request using CreateThemeRequest.
//    req := client.CreateThemeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme
func (c *Client) CreateThemeRequest(input *CreateThemeInput) CreateThemeRequest {
	op := &aws.Operation{
		Name:       opCreateTheme,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &CreateThemeInput{}
	}

	req := c.newRequest(op, input, &CreateThemeOutput{})

	return CreateThemeRequest{Request: req, Input: input, Copy: c.CreateThemeRequest}
}

// CreateThemeRequest is the request type for the
// CreateTheme API operation.
type CreateThemeRequest struct {
	*aws.Request
	Input *CreateThemeInput
	Copy  func(*CreateThemeInput) CreateThemeRequest
}

// Send marshals and sends the CreateTheme API request.
func (r CreateThemeRequest) Send(ctx context.Context) (*CreateThemeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateThemeResponse{
		CreateThemeOutput: r.Request.Data.(*CreateThemeOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateThemeResponse is the response type for the
// CreateTheme API operation.
type CreateThemeResponse struct {
	*CreateThemeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTheme request.
func (r *CreateThemeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
