// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the template that you're deleting.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the template you want to delete.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// Specifies the version of the template that you want to delete. If you don't
	// provide a version number, DeleteTemplate deletes all versions of the template.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation
func (s DeleteTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTemplateInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.TemplateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateId != nil {
		v := *s.TemplateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "TemplateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version-number", protocol.Int64Value(v), metadata)
	}
	return nil
}

type DeleteTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// An ID for the template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateId != nil {
		v := *s.TemplateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDeleteTemplate = "DeleteTemplate"

// DeleteTemplateRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Deletes a template.
//
//    // Example sending a request using DeleteTemplateRequest.
//    req := client.DeleteTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate
func (c *Client) DeleteTemplateRequest(input *DeleteTemplateInput) DeleteTemplateRequest {
	op := &aws.Operation{
		Name:       opDeleteTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DeleteTemplateInput{}
	}

	req := c.newRequest(op, input, &DeleteTemplateOutput{})

	return DeleteTemplateRequest{Request: req, Input: input, Copy: c.DeleteTemplateRequest}
}

// DeleteTemplateRequest is the request type for the
// DeleteTemplate API operation.
type DeleteTemplateRequest struct {
	*aws.Request
	Input *DeleteTemplateInput
	Copy  func(*DeleteTemplateInput) DeleteTemplateRequest
}

// Send marshals and sends the DeleteTemplate API request.
func (r DeleteTemplateRequest) Send(ctx context.Context) (*DeleteTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTemplateResponse{
		DeleteTemplateOutput: r.Request.Data.(*DeleteTemplateOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTemplateResponse is the response type for the
// DeleteTemplate API operation.
type DeleteTemplateResponse struct {
	*DeleteTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTemplate request.
func (r *DeleteTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
