// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteThemeAliasInput struct {
	_ struct{} `type:"structure"`

	// The unique name for the theme alias to delete.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the AWS account that contains the theme alias to delete.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the theme that the specified alias is for.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThemeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThemeAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteThemeAliasInput"}

	if s.AliasName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AliasName", 1))
	}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.ThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThemeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteThemeAliasInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AliasName != nil {
		v := *s.AliasName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AliasName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteThemeAliasOutput struct {
	_ struct{} `type:"structure"`

	// The name for the theme alias.
	AliasName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the theme resource using the deleted alias.
	Arn *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// An ID for the theme associated with the deletion.
	ThemeId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteThemeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteThemeAliasOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AliasName != nil {
		v := *s.AliasName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AliasName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDeleteThemeAlias = "DeleteThemeAlias"

// DeleteThemeAliasRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Deletes the version of the theme that the specified theme alias points to.
// If you provide a specific alias, you delete the version of the theme that
// the alias points to.
//
//    // Example sending a request using DeleteThemeAliasRequest.
//    req := client.DeleteThemeAliasRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias
func (c *Client) DeleteThemeAliasRequest(input *DeleteThemeAliasInput) DeleteThemeAliasRequest {
	op := &aws.Operation{
		Name:       opDeleteThemeAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DeleteThemeAliasInput{}
	}

	req := c.newRequest(op, input, &DeleteThemeAliasOutput{})

	return DeleteThemeAliasRequest{Request: req, Input: input, Copy: c.DeleteThemeAliasRequest}
}

// DeleteThemeAliasRequest is the request type for the
// DeleteThemeAlias API operation.
type DeleteThemeAliasRequest struct {
	*aws.Request
	Input *DeleteThemeAliasInput
	Copy  func(*DeleteThemeAliasInput) DeleteThemeAliasRequest
}

// Send marshals and sends the DeleteThemeAlias API request.
func (r DeleteThemeAliasRequest) Send(ctx context.Context) (*DeleteThemeAliasResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteThemeAliasResponse{
		DeleteThemeAliasOutput: r.Request.Data.(*DeleteThemeAliasOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteThemeAliasResponse is the response type for the
// DeleteThemeAlias API operation.
type DeleteThemeAliasResponse struct {
	*DeleteThemeAliasOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteThemeAlias request.
func (r *DeleteThemeAliasResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
