// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeDashboardInput struct {
	_ struct{} `type:"structure"`

	// The alias name.
	AliasName *string `location:"querystring" locationName:"alias-name" min:"1" type:"string"`

	// The ID of the AWS account that contains the dashboard that you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The version number for the dashboard. If a version number isn't passed, the
	// latest published dashboard version is described.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation
func (s DescribeDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDashboardInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDashboardInput"}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AliasName", 1))
	}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.DashboardId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DashboardId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDashboardInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AliasName != nil {
		v := *s.AliasName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "alias-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version-number", protocol.Int64Value(v), metadata)
	}
	return nil
}

type DescribeDashboardOutput struct {
	_ struct{} `type:"structure"`

	// Information about the dashboard.
	Dashboard *Dashboard `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of this request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDashboardOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dashboard != nil {
		v := s.Dashboard

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dashboard", v, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDescribeDashboard = "DescribeDashboard"

// DescribeDashboardRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Provides a summary for a dashboard.
//
//    // Example sending a request using DescribeDashboardRequest.
//    req := client.DescribeDashboardRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard
func (c *Client) DescribeDashboardRequest(input *DescribeDashboardInput) DescribeDashboardRequest {
	op := &aws.Operation{
		Name:       opDescribeDashboard,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &DescribeDashboardInput{}
	}

	req := c.newRequest(op, input, &DescribeDashboardOutput{})

	return DescribeDashboardRequest{Request: req, Input: input, Copy: c.DescribeDashboardRequest}
}

// DescribeDashboardRequest is the request type for the
// DescribeDashboard API operation.
type DescribeDashboardRequest struct {
	*aws.Request
	Input *DescribeDashboardInput
	Copy  func(*DescribeDashboardInput) DescribeDashboardRequest
}

// Send marshals and sends the DescribeDashboard API request.
func (r DescribeDashboardRequest) Send(ctx context.Context) (*DescribeDashboardResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDashboardResponse{
		DescribeDashboardOutput: r.Request.Data.(*DescribeDashboardOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDashboardResponse is the response type for the
// DescribeDashboard API operation.
type DescribeDashboardResponse struct {
	*DescribeDashboardOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDashboard request.
func (r *DescribeDashboardResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
