// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeDashboardPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the dashboard that you're describing
	// permissions for.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to the IAM policy.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDashboardPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDashboardPermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDashboardPermissionsInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.DashboardId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DashboardId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDashboardPermissionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeDashboardPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// A structure that contains the permissions for the dashboard.
	Permissions []ResourcePermission `min:"1" type:"list"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDashboardPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDashboardPermissionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DashboardArn != nil {
		v := *s.DashboardArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DashboardArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Permissions != nil {
		v := s.Permissions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Permissions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDescribeDashboardPermissions = "DescribeDashboardPermissions"

// DescribeDashboardPermissionsRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Describes read and write permissions for a dashboard.
//
//    // Example sending a request using DescribeDashboardPermissionsRequest.
//    req := client.DescribeDashboardPermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions
func (c *Client) DescribeDashboardPermissionsRequest(input *DescribeDashboardPermissionsInput) DescribeDashboardPermissionsRequest {
	op := &aws.Operation{
		Name:       opDescribeDashboardPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
	}

	if input == nil {
		input = &DescribeDashboardPermissionsInput{}
	}

	req := c.newRequest(op, input, &DescribeDashboardPermissionsOutput{})

	return DescribeDashboardPermissionsRequest{Request: req, Input: input, Copy: c.DescribeDashboardPermissionsRequest}
}

// DescribeDashboardPermissionsRequest is the request type for the
// DescribeDashboardPermissions API operation.
type DescribeDashboardPermissionsRequest struct {
	*aws.Request
	Input *DescribeDashboardPermissionsInput
	Copy  func(*DescribeDashboardPermissionsInput) DescribeDashboardPermissionsRequest
}

// Send marshals and sends the DescribeDashboardPermissions API request.
func (r DescribeDashboardPermissionsRequest) Send(ctx context.Context) (*DescribeDashboardPermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDashboardPermissionsResponse{
		DescribeDashboardPermissionsOutput: r.Request.Data.(*DescribeDashboardPermissionsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDashboardPermissionsResponse is the response type for the
// DescribeDashboardPermissions API operation.
type DescribeDashboardPermissionsResponse struct {
	*DescribeDashboardPermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDashboardPermissions request.
func (r *DescribeDashboardPermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
