// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeThemeInput struct {
	_ struct{} `type:"structure"`

	// The alias of the theme that you want to describe. If you name a specific
	// alias, you describe the version that the alias points to. You can specify
	// the latest version of the theme by providing the keyword $LATEST in the AliasName
	// parameter. The keyword $PUBLISHED doesn't apply to themes.
	AliasName *string `location:"querystring" locationName:"alias-name" min:"1" type:"string"`

	// The ID of the AWS account that contains the theme that you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" type:"string" required:"true"`

	// The ID for the theme.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// The version number for the version to describe. If a VersionNumber parameter
	// value isn't provided, the latest version of the theme is described.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation
func (s DescribeThemeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThemeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeThemeInput"}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AliasName", 1))
	}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}

	if s.ThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThemeId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeThemeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AliasName != nil {
		v := *s.AliasName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "alias-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version-number", protocol.Int64Value(v), metadata)
	}
	return nil
}

type DescribeThemeOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The information about the theme that you are describing.
	Theme *Theme `type:"structure"`
}

// String returns the string representation
func (s DescribeThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeThemeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Theme != nil {
		v := s.Theme

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Theme", v, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDescribeTheme = "DescribeTheme"

// DescribeThemeRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Describes a theme.
//
//    // Example sending a request using DescribeThemeRequest.
//    req := client.DescribeThemeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme
func (c *Client) DescribeThemeRequest(input *DescribeThemeInput) DescribeThemeRequest {
	op := &aws.Operation{
		Name:       opDescribeTheme,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &DescribeThemeInput{}
	}

	req := c.newRequest(op, input, &DescribeThemeOutput{})

	return DescribeThemeRequest{Request: req, Input: input, Copy: c.DescribeThemeRequest}
}

// DescribeThemeRequest is the request type for the
// DescribeTheme API operation.
type DescribeThemeRequest struct {
	*aws.Request
	Input *DescribeThemeInput
	Copy  func(*DescribeThemeInput) DescribeThemeRequest
}

// Send marshals and sends the DescribeTheme API request.
func (r DescribeThemeRequest) Send(ctx context.Context) (*DescribeThemeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeThemeResponse{
		DescribeThemeOutput: r.Request.Data.(*DescribeThemeOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeThemeResponse is the response type for the
// DescribeTheme API operation.
type DescribeThemeResponse struct {
	*DescribeThemeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTheme request.
func (r *DescribeThemeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
