// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeThemeAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the theme alias that you want to describe.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the AWS account that contains the theme alias that you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the theme.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeThemeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThemeAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeThemeAliasInput"}

	if s.AliasName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AliasName", 1))
	}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.ThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThemeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeThemeAliasInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AliasName != nil {
		v := *s.AliasName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AliasName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeThemeAliasOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information about the theme alias.
	ThemeAlias *ThemeAlias `type:"structure"`
}

// String returns the string representation
func (s DescribeThemeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeThemeAliasOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeAlias != nil {
		v := s.ThemeAlias

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ThemeAlias", v, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDescribeThemeAlias = "DescribeThemeAlias"

// DescribeThemeAliasRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Describes the alias for a theme.
//
//    // Example sending a request using DescribeThemeAliasRequest.
//    req := client.DescribeThemeAliasRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias
func (c *Client) DescribeThemeAliasRequest(input *DescribeThemeAliasInput) DescribeThemeAliasRequest {
	op := &aws.Operation{
		Name:       opDescribeThemeAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DescribeThemeAliasInput{}
	}

	req := c.newRequest(op, input, &DescribeThemeAliasOutput{})

	return DescribeThemeAliasRequest{Request: req, Input: input, Copy: c.DescribeThemeAliasRequest}
}

// DescribeThemeAliasRequest is the request type for the
// DescribeThemeAlias API operation.
type DescribeThemeAliasRequest struct {
	*aws.Request
	Input *DescribeThemeAliasInput
	Copy  func(*DescribeThemeAliasInput) DescribeThemeAliasRequest
}

// Send marshals and sends the DescribeThemeAlias API request.
func (r DescribeThemeAliasRequest) Send(ctx context.Context) (*DescribeThemeAliasResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeThemeAliasResponse{
		DescribeThemeAliasOutput: r.Request.Data.(*DescribeThemeAliasOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeThemeAliasResponse is the response type for the
// DescribeThemeAlias API operation.
type DescribeThemeAliasResponse struct {
	*DescribeThemeAliasOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeThemeAlias request.
func (r *DescribeThemeAliasResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
