// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListDataSourcesInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDataSourcesInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDataSourcesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of data sources.
	DataSources []DataSource `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDataSourcesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSources != nil {
		v := s.DataSources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DataSources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Lists data sources in current AWS Region that belong to this AWS account.
//
//    // Example sending a request using ListDataSourcesRequest.
//    req := client.ListDataSourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources
func (c *Client) ListDataSourcesRequest(input *ListDataSourcesInput) ListDataSourcesRequest {
	op := &aws.Operation{
		Name:       opListDataSources,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	req := c.newRequest(op, input, &ListDataSourcesOutput{})

	return ListDataSourcesRequest{Request: req, Input: input, Copy: c.ListDataSourcesRequest}
}

// ListDataSourcesRequest is the request type for the
// ListDataSources API operation.
type ListDataSourcesRequest struct {
	*aws.Request
	Input *ListDataSourcesInput
	Copy  func(*ListDataSourcesInput) ListDataSourcesRequest
}

// Send marshals and sends the ListDataSources API request.
func (r ListDataSourcesRequest) Send(ctx context.Context) (*ListDataSourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDataSourcesResponse{
		ListDataSourcesOutput: r.Request.Data.(*ListDataSourcesOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDataSourcesRequestPaginator returns a paginator for ListDataSources.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDataSourcesRequest(input)
//   p := quicksight.NewListDataSourcesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDataSourcesPaginator(req ListDataSourcesRequest) ListDataSourcesPaginator {
	return ListDataSourcesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDataSourcesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDataSourcesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDataSourcesPaginator struct {
	aws.Pager
}

func (p *ListDataSourcesPaginator) CurrentPage() *ListDataSourcesOutput {
	return p.Pager.CurrentPage().(*ListDataSourcesOutput)
}

// ListDataSourcesResponse is the response type for the
// ListDataSources API operation.
type ListDataSourcesResponse struct {
	*ListDataSourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDataSources request.
func (r *ListDataSourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
