// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListIngestionsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListIngestionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIngestionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListIngestionsInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListIngestionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListIngestionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the ingestions.
	Ingestions []Ingestion `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListIngestionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListIngestionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Ingestions != nil {
		v := s.Ingestions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Ingestions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opListIngestions = "ListIngestions"

// ListIngestionsRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Lists the history of SPICE ingestions for a dataset.
//
//    // Example sending a request using ListIngestionsRequest.
//    req := client.ListIngestionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions
func (c *Client) ListIngestionsRequest(input *ListIngestionsInput) ListIngestionsRequest {
	op := &aws.Operation{
		Name:       opListIngestions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngestionsInput{}
	}

	req := c.newRequest(op, input, &ListIngestionsOutput{})

	return ListIngestionsRequest{Request: req, Input: input, Copy: c.ListIngestionsRequest}
}

// ListIngestionsRequest is the request type for the
// ListIngestions API operation.
type ListIngestionsRequest struct {
	*aws.Request
	Input *ListIngestionsInput
	Copy  func(*ListIngestionsInput) ListIngestionsRequest
}

// Send marshals and sends the ListIngestions API request.
func (r ListIngestionsRequest) Send(ctx context.Context) (*ListIngestionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListIngestionsResponse{
		ListIngestionsOutput: r.Request.Data.(*ListIngestionsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListIngestionsRequestPaginator returns a paginator for ListIngestions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListIngestionsRequest(input)
//   p := quicksight.NewListIngestionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListIngestionsPaginator(req ListIngestionsRequest) ListIngestionsPaginator {
	return ListIngestionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListIngestionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListIngestionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListIngestionsPaginator struct {
	aws.Pager
}

func (p *ListIngestionsPaginator) CurrentPage() *ListIngestionsOutput {
	return p.Pager.CurrentPage().(*ListIngestionsOutput)
}

// ListIngestionsResponse is the response type for the
// ListIngestions API operation.
type ListIngestionsResponse struct {
	*ListIngestionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListIngestions request.
func (r *ListIngestionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
