// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListThemeAliasesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the theme aliases that you're listing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-result" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The ID for the theme.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListThemeAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThemeAliasesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListThemeAliasesInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThemeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThemeAliasesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-result", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListThemeAliasesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// A structure containing the list of the theme's aliases.
	ThemeAliasList []ThemeAlias `type:"list"`
}

// String returns the string representation
func (s ListThemeAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThemeAliasesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeAliasList != nil {
		v := s.ThemeAliasList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThemeAliasList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opListThemeAliases = "ListThemeAliases"

// ListThemeAliasesRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Lists all the aliases of a theme.
//
//    // Example sending a request using ListThemeAliasesRequest.
//    req := client.ListThemeAliasesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases
func (c *Client) ListThemeAliasesRequest(input *ListThemeAliasesInput) ListThemeAliasesRequest {
	op := &aws.Operation{
		Name:       opListThemeAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases",
	}

	if input == nil {
		input = &ListThemeAliasesInput{}
	}

	req := c.newRequest(op, input, &ListThemeAliasesOutput{})

	return ListThemeAliasesRequest{Request: req, Input: input, Copy: c.ListThemeAliasesRequest}
}

// ListThemeAliasesRequest is the request type for the
// ListThemeAliases API operation.
type ListThemeAliasesRequest struct {
	*aws.Request
	Input *ListThemeAliasesInput
	Copy  func(*ListThemeAliasesInput) ListThemeAliasesRequest
}

// Send marshals and sends the ListThemeAliases API request.
func (r ListThemeAliasesRequest) Send(ctx context.Context) (*ListThemeAliasesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListThemeAliasesResponse{
		ListThemeAliasesOutput: r.Request.Data.(*ListThemeAliasesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListThemeAliasesResponse is the response type for the
// ListThemeAliases API operation.
type ListThemeAliasesResponse struct {
	*ListThemeAliasesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListThemeAliases request.
func (r *ListThemeAliasesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
