// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListThemeVersionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the themes that you're listing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The ID for the theme.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListThemeVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThemeVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListThemeVersionsInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThemeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThemeVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListThemeVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// A structure containing a list of all the versions of the specified theme.
	ThemeVersionSummaryList []ThemeVersionSummary `type:"list"`
}

// String returns the string representation
func (s ListThemeVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThemeVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeVersionSummaryList != nil {
		v := s.ThemeVersionSummaryList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThemeVersionSummaryList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opListThemeVersions = "ListThemeVersions"

// ListThemeVersionsRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Lists all the versions of the themes in the current AWS account.
//
//    // Example sending a request using ListThemeVersionsRequest.
//    req := client.ListThemeVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions
func (c *Client) ListThemeVersionsRequest(input *ListThemeVersionsInput) ListThemeVersionsRequest {
	op := &aws.Operation{
		Name:       opListThemeVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/versions",
	}

	if input == nil {
		input = &ListThemeVersionsInput{}
	}

	req := c.newRequest(op, input, &ListThemeVersionsOutput{})

	return ListThemeVersionsRequest{Request: req, Input: input, Copy: c.ListThemeVersionsRequest}
}

// ListThemeVersionsRequest is the request type for the
// ListThemeVersions API operation.
type ListThemeVersionsRequest struct {
	*aws.Request
	Input *ListThemeVersionsInput
	Copy  func(*ListThemeVersionsInput) ListThemeVersionsRequest
}

// Send marshals and sends the ListThemeVersions API request.
func (r ListThemeVersionsRequest) Send(ctx context.Context) (*ListThemeVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListThemeVersionsResponse{
		ListThemeVersionsOutput: r.Request.Data.(*ListThemeVersionsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListThemeVersionsResponse is the response type for the
// ListThemeVersions API operation.
type ListThemeVersionsResponse struct {
	*ListThemeVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListThemeVersions request.
func (r *ListThemeVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
