// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type SearchDashboardsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the user whose dashboards you're
	// searching for.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The filters to apply to the search. Currently, you can search only by user
	// name, for example, "Filters": [ { "Name": "QUICKSIGHT_USER", "Operator":
	// "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"
	// } ]
	//
	// Filters is a required field
	Filters []DashboardSearchFilter `type:"list" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SearchDashboardsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchDashboardsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchDashboardsInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SearchDashboardsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Filters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type SearchDashboardsOutput struct {
	_ struct{} `type:"structure"`

	// The list of dashboards owned by the user specified in Filters in your request.
	DashboardSummaryList []DashboardSummary `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s SearchDashboardsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SearchDashboardsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DashboardSummaryList != nil {
		v := s.DashboardSummaryList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DashboardSummaryList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opSearchDashboards = "SearchDashboards"

// SearchDashboardsRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Searchs for dashboards that belong to a user.
//
//    // Example sending a request using SearchDashboardsRequest.
//    req := client.SearchDashboardsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards
func (c *Client) SearchDashboardsRequest(input *SearchDashboardsInput) SearchDashboardsRequest {
	op := &aws.Operation{
		Name:       opSearchDashboards,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/dashboards",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDashboardsInput{}
	}

	req := c.newRequest(op, input, &SearchDashboardsOutput{})

	return SearchDashboardsRequest{Request: req, Input: input, Copy: c.SearchDashboardsRequest}
}

// SearchDashboardsRequest is the request type for the
// SearchDashboards API operation.
type SearchDashboardsRequest struct {
	*aws.Request
	Input *SearchDashboardsInput
	Copy  func(*SearchDashboardsInput) SearchDashboardsRequest
}

// Send marshals and sends the SearchDashboards API request.
func (r SearchDashboardsRequest) Send(ctx context.Context) (*SearchDashboardsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchDashboardsResponse{
		SearchDashboardsOutput: r.Request.Data.(*SearchDashboardsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchDashboardsRequestPaginator returns a paginator for SearchDashboards.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchDashboardsRequest(input)
//   p := quicksight.NewSearchDashboardsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchDashboardsPaginator(req SearchDashboardsRequest) SearchDashboardsPaginator {
	return SearchDashboardsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchDashboardsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchDashboardsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchDashboardsPaginator struct {
	aws.Pager
}

func (p *SearchDashboardsPaginator) CurrentPage() *SearchDashboardsOutput {
	return p.Pager.CurrentPage().(*SearchDashboardsOutput)
}

// SearchDashboardsResponse is the response type for the
// SearchDashboards API operation.
type SearchDashboardsResponse struct {
	*SearchDashboardsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchDashboards request.
func (r *SearchDashboardsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
