// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ram

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisassociateResourceSharePermissionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The ARN of the permission to disassociate from the resource share.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateResourceSharePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResourceSharePermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateResourceSharePermissionInput"}

	if s.PermissionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PermissionArn"))
	}

	if s.ResourceShareArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateResourceSharePermissionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClientToken != nil {
		v := *s.ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PermissionArn != nil {
		v := *s.PermissionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "permissionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceShareArn != nil {
		v := *s.ResourceShareArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceShareArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisassociateResourceSharePermissionOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Indicates whether the request succeeded.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation
func (s DisassociateResourceSharePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateResourceSharePermissionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClientToken != nil {
		v := *s.ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReturnValue != nil {
		v := *s.ReturnValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "returnValue", protocol.BoolValue(v), metadata)
	}
	return nil
}

const opDisassociateResourceSharePermission = "DisassociateResourceSharePermission"

// DisassociateResourceSharePermissionRequest returns a request value for making API operation for
// AWS Resource Access Manager.
//
// Disassociates an AWS RAM permission from a resource share.
//
//    // Example sending a request using DisassociateResourceSharePermissionRequest.
//    req := client.DisassociateResourceSharePermissionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceSharePermission
func (c *Client) DisassociateResourceSharePermissionRequest(input *DisassociateResourceSharePermissionInput) DisassociateResourceSharePermissionRequest {
	op := &aws.Operation{
		Name:       opDisassociateResourceSharePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociateresourcesharepermission",
	}

	if input == nil {
		input = &DisassociateResourceSharePermissionInput{}
	}

	req := c.newRequest(op, input, &DisassociateResourceSharePermissionOutput{})

	return DisassociateResourceSharePermissionRequest{Request: req, Input: input, Copy: c.DisassociateResourceSharePermissionRequest}
}

// DisassociateResourceSharePermissionRequest is the request type for the
// DisassociateResourceSharePermission API operation.
type DisassociateResourceSharePermissionRequest struct {
	*aws.Request
	Input *DisassociateResourceSharePermissionInput
	Copy  func(*DisassociateResourceSharePermissionInput) DisassociateResourceSharePermissionRequest
}

// Send marshals and sends the DisassociateResourceSharePermission API request.
func (r DisassociateResourceSharePermissionRequest) Send(ctx context.Context) (*DisassociateResourceSharePermissionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateResourceSharePermissionResponse{
		DisassociateResourceSharePermissionOutput: r.Request.Data.(*DisassociateResourceSharePermissionOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateResourceSharePermissionResponse is the response type for the
// DisassociateResourceSharePermission API operation.
type DisassociateResourceSharePermissionResponse struct {
	*DisassociateResourceSharePermissionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateResourceSharePermission request.
func (r *DisassociateResourceSharePermissionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
