// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ram

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetResourceShareInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Names (ARN) of the resource shares.
	ResourceShareArns []string `locationName:"resourceShareArns" type:"list"`

	// The Amazon Resource Names (ARN) of the invitations.
	ResourceShareInvitationArns []string `locationName:"resourceShareInvitationArns" type:"list"`
}

// String returns the string representation
func (s GetResourceShareInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceShareInvitationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetResourceShareInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetResourceShareInvitationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceShareArns != nil {
		v := s.ResourceShareArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resourceShareArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ResourceShareInvitationArns != nil {
		v := s.ResourceShareInvitationArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resourceShareInvitationArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type GetResourceShareInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the invitations.
	ResourceShareInvitations []ResourceShareInvitation `locationName:"resourceShareInvitations" type:"list"`
}

// String returns the string representation
func (s GetResourceShareInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetResourceShareInvitationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceShareInvitations != nil {
		v := s.ResourceShareInvitations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resourceShareInvitations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetResourceShareInvitations = "GetResourceShareInvitations"

// GetResourceShareInvitationsRequest returns a request value for making API operation for
// AWS Resource Access Manager.
//
// Gets the invitations for resource sharing that you've received.
//
//    // Example sending a request using GetResourceShareInvitationsRequest.
//    req := client.GetResourceShareInvitationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations
func (c *Client) GetResourceShareInvitationsRequest(input *GetResourceShareInvitationsInput) GetResourceShareInvitationsRequest {
	op := &aws.Operation{
		Name:       opGetResourceShareInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/getresourceshareinvitations",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceShareInvitationsInput{}
	}

	req := c.newRequest(op, input, &GetResourceShareInvitationsOutput{})

	return GetResourceShareInvitationsRequest{Request: req, Input: input, Copy: c.GetResourceShareInvitationsRequest}
}

// GetResourceShareInvitationsRequest is the request type for the
// GetResourceShareInvitations API operation.
type GetResourceShareInvitationsRequest struct {
	*aws.Request
	Input *GetResourceShareInvitationsInput
	Copy  func(*GetResourceShareInvitationsInput) GetResourceShareInvitationsRequest
}

// Send marshals and sends the GetResourceShareInvitations API request.
func (r GetResourceShareInvitationsRequest) Send(ctx context.Context) (*GetResourceShareInvitationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetResourceShareInvitationsResponse{
		GetResourceShareInvitationsOutput: r.Request.Data.(*GetResourceShareInvitationsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetResourceShareInvitationsRequestPaginator returns a paginator for GetResourceShareInvitations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetResourceShareInvitationsRequest(input)
//   p := ram.NewGetResourceShareInvitationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetResourceShareInvitationsPaginator(req GetResourceShareInvitationsRequest) GetResourceShareInvitationsPaginator {
	return GetResourceShareInvitationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetResourceShareInvitationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetResourceShareInvitationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetResourceShareInvitationsPaginator struct {
	aws.Pager
}

func (p *GetResourceShareInvitationsPaginator) CurrentPage() *GetResourceShareInvitationsOutput {
	return p.Pager.CurrentPage().(*GetResourceShareInvitationsOutput)
}

// GetResourceShareInvitationsResponse is the response type for the
// GetResourceShareInvitations API operation.
type GetResourceShareInvitationsResponse struct {
	*GetResourceShareInvitationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetResourceShareInvitations request.
func (r *GetResourceShareInvitationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
