// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ram

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListResourceTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListResourceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceTypesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResourceTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListResourceTypesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListResourceTypesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The shareable resource types supported by AWS RAM.
	ResourceTypes []ServiceNameAndResourceType `locationName:"resourceTypes" type:"list"`
}

// String returns the string representation
func (s ListResourceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListResourceTypesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceTypes != nil {
		v := s.ResourceTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resourceTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListResourceTypes = "ListResourceTypes"

// ListResourceTypesRequest returns a request value for making API operation for
// AWS Resource Access Manager.
//
// Lists the shareable resource types supported by AWS RAM.
//
//    // Example sending a request using ListResourceTypesRequest.
//    req := client.ListResourceTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes
func (c *Client) ListResourceTypesRequest(input *ListResourceTypesInput) ListResourceTypesRequest {
	op := &aws.Operation{
		Name:       opListResourceTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/listresourcetypes",
	}

	if input == nil {
		input = &ListResourceTypesInput{}
	}

	req := c.newRequest(op, input, &ListResourceTypesOutput{})

	return ListResourceTypesRequest{Request: req, Input: input, Copy: c.ListResourceTypesRequest}
}

// ListResourceTypesRequest is the request type for the
// ListResourceTypes API operation.
type ListResourceTypesRequest struct {
	*aws.Request
	Input *ListResourceTypesInput
	Copy  func(*ListResourceTypesInput) ListResourceTypesRequest
}

// Send marshals and sends the ListResourceTypes API request.
func (r ListResourceTypesRequest) Send(ctx context.Context) (*ListResourceTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResourceTypesResponse{
		ListResourceTypesOutput: r.Request.Data.(*ListResourceTypesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListResourceTypesResponse is the response type for the
// ListResourceTypes API operation.
type ListResourceTypesResponse struct {
	*ListResourceTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResourceTypes request.
func (r *ListResourceTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
