// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDBSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB security group.
	//
	// DBSecurityGroupDescription is a required field
	DBSecurityGroupDescription *string `type:"string" required:"true"`

	// The name for the DB security group. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	//    * Must not be "Default"
	//
	// Example: mysecuritygroup
	//
	// DBSecurityGroupName is a required field
	DBSecurityGroupName *string `type:"string" required:"true"`

	// Tags to assign to the DB security group.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBSecurityGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDBSecurityGroupInput"}

	if s.DBSecurityGroupDescription == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBSecurityGroupDescription"))
	}

	if s.DBSecurityGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDBSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon RDS DB security group.
	//
	// This data type is used as a response element in the DescribeDBSecurityGroups
	// action.
	DBSecurityGroup *DBSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDBSecurityGroup = "CreateDBSecurityGroup"

// CreateDBSecurityGroupRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Creates a new DB security group. DB security groups control access to a DB
// instance.
//
// A DB security group controls access to EC2-Classic DB instances that are
// not in a VPC.
//
//    // Example sending a request using CreateDBSecurityGroupRequest.
//    req := client.CreateDBSecurityGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup
func (c *Client) CreateDBSecurityGroupRequest(input *CreateDBSecurityGroupInput) CreateDBSecurityGroupRequest {
	op := &aws.Operation{
		Name:       opCreateDBSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSecurityGroupInput{}
	}

	req := c.newRequest(op, input, &CreateDBSecurityGroupOutput{})

	return CreateDBSecurityGroupRequest{Request: req, Input: input, Copy: c.CreateDBSecurityGroupRequest}
}

// CreateDBSecurityGroupRequest is the request type for the
// CreateDBSecurityGroup API operation.
type CreateDBSecurityGroupRequest struct {
	*aws.Request
	Input *CreateDBSecurityGroupInput
	Copy  func(*CreateDBSecurityGroupInput) CreateDBSecurityGroupRequest
}

// Send marshals and sends the CreateDBSecurityGroup API request.
func (r CreateDBSecurityGroupRequest) Send(ctx context.Context) (*CreateDBSecurityGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDBSecurityGroupResponse{
		CreateDBSecurityGroupOutput: r.Request.Data.(*CreateDBSecurityGroupOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDBSecurityGroupResponse is the response type for the
// CreateDBSecurityGroup API operation.
type CreateDBSecurityGroupResponse struct {
	*CreateDBSecurityGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDBSecurityGroup request.
func (r *CreateDBSecurityGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
