// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The new default certificate identifier to override the current one with.
	//
	// To determine the valid values, use the describe-certificates AWS CLI command
	// or the DescribeCertificates API operation.
	CertificateIdentifier *string `type:"string"`

	// A value that indicates whether to remove the override for the default certificate.
	// If the override is removed, the default certificate is the system default.
	RemoveCustomerOverride *bool `type:"boolean"`
}

// String returns the string representation
func (s ModifyCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

type ModifyCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A CA certificate for an AWS account.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation
func (s ModifyCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyCertificates = "ModifyCertificates"

// ModifyCertificatesRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Override the system-default Secure Sockets Layer/Transport Layer Security
// (SSL/TLS) certificate for Amazon RDS for new DB instances temporarily, or
// remove the override.
//
// By using this operation, you can specify an RDS-approved SSL/TLS certificate
// for new DB instances that is different from the default certificate provided
// by RDS. You can also use this operation to remove the override, so that new
// DB instances use the default certificate provided by RDS.
//
// You might need to override the default certificate in the following situations:
//
//    * You already migrated your applications to support the latest certificate
//    authority (CA) certificate, but the new CA certificate is not yet the
//    RDS default CA certificate for the specified AWS Region.
//
//    * RDS has already moved to a new default CA certificate for the specified
//    AWS Region, but you are still in the process of supporting the new CA
//    certificate. In this case, you temporarily need additional time to finish
//    your application changes.
//
// For more information about rotating your SSL/TLS certificate for RDS DB engines,
// see Rotating Your SSL/TLS Certificate (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html)
// in the Amazon RDS User Guide.
//
// For more information about rotating your SSL/TLS certificate for Aurora DB
// engines, see Rotating Your SSL/TLS Certificate (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html)
// in the Amazon Aurora User Guide.
//
//    // Example sending a request using ModifyCertificatesRequest.
//    req := client.ModifyCertificatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCertificates
func (c *Client) ModifyCertificatesRequest(input *ModifyCertificatesInput) ModifyCertificatesRequest {
	op := &aws.Operation{
		Name:       opModifyCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCertificatesInput{}
	}

	req := c.newRequest(op, input, &ModifyCertificatesOutput{})

	return ModifyCertificatesRequest{Request: req, Input: input, Copy: c.ModifyCertificatesRequest}
}

// ModifyCertificatesRequest is the request type for the
// ModifyCertificates API operation.
type ModifyCertificatesRequest struct {
	*aws.Request
	Input *ModifyCertificatesInput
	Copy  func(*ModifyCertificatesInput) ModifyCertificatesRequest
}

// Send marshals and sends the ModifyCertificates API request.
func (r ModifyCertificatesRequest) Send(ctx context.Context) (*ModifyCertificatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyCertificatesResponse{
		ModifyCertificatesOutput: r.Request.Data.(*ModifyCertificatesOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyCertificatesResponse is the response type for the
// ModifyCertificates API operation.
type ModifyCertificatesResponse struct {
	*ModifyCertificatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyCertificates request.
func (r *ModifyCertificatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
