// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartActivityStreamInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether or not the database activity stream is to start as soon
	// as possible, regardless of the maintenance window for the database.
	ApplyImmediately *bool `type:"boolean"`

	// The AWS KMS key identifier for encrypting messages in the database activity
	// stream. The key identifier can be either a key ID, a key ARN, or a key alias.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `type:"string" required:"true"`

	// Specifies the mode of the database activity stream. Database events such
	// as a change or access generate an activity stream event. The database session
	// can handle these events either synchronously or asynchronously.
	//
	// Mode is a required field
	Mode ActivityStreamMode `type:"string" required:"true" enum:"true"`

	// The Amazon Resource Name (ARN) of the DB cluster, for example arn:aws:rds:us-east-1:12345667890:cluster:das-cluster.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartActivityStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartActivityStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartActivityStreamInput"}

	if s.KmsKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KmsKeyId"))
	}
	if len(s.Mode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Mode"))
	}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartActivityStreamOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether or not the database activity stream will start as soon
	// as possible, regardless of the maintenance window for the database.
	ApplyImmediately *bool `type:"boolean"`

	// The name of the Amazon Kinesis data stream to be used for the database activity
	// stream.
	KinesisStreamName *string `type:"string"`

	// The AWS KMS key identifier for encryption of messages in the database activity
	// stream.
	KmsKeyId *string `type:"string"`

	// The mode of the database activity stream.
	Mode ActivityStreamMode `type:"string" enum:"true"`

	// The status of the database activity stream.
	Status ActivityStreamStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StartActivityStreamOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartActivityStream = "StartActivityStream"

// StartActivityStreamRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Starts a database activity stream to monitor activity on the database. For
// more information, see Database Activity Streams (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html)
// in the Amazon Aurora User Guide.
//
//    // Example sending a request using StartActivityStreamRequest.
//    req := client.StartActivityStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartActivityStream
func (c *Client) StartActivityStreamRequest(input *StartActivityStreamInput) StartActivityStreamRequest {
	op := &aws.Operation{
		Name:       opStartActivityStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartActivityStreamInput{}
	}

	req := c.newRequest(op, input, &StartActivityStreamOutput{})

	return StartActivityStreamRequest{Request: req, Input: input, Copy: c.StartActivityStreamRequest}
}

// StartActivityStreamRequest is the request type for the
// StartActivityStream API operation.
type StartActivityStreamRequest struct {
	*aws.Request
	Input *StartActivityStreamInput
	Copy  func(*StartActivityStreamInput) StartActivityStreamRequest
}

// Send marshals and sends the StartActivityStream API request.
func (r StartActivityStreamRequest) Send(ctx context.Context) (*StartActivityStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartActivityStreamResponse{
		StartActivityStreamOutput: r.Request.Data.(*StartActivityStreamOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartActivityStreamResponse is the response type for the
// StartActivityStream API operation.
type StartActivityStreamResponse struct {
	*StartActivityStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartActivityStream request.
func (r *StartActivityStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
