// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied instance identifier.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The user-supplied instance identifier of the DB Snapshot created immediately
	// before the DB instance is stopped.
	DBSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s StopDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDBInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopDBInstanceInput"}

	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB instance.
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s StopDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopDBInstance = "StopDBInstance"

// StopDBInstanceRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS
// retains the DB instance's metadata, including its endpoint, DB parameter
// group, and option group membership. Amazon RDS also retains the transaction
// logs so you can do a point-in-time restore if necessary.
//
// For more information, see Stopping an Amazon RDS DB Instance Temporarily
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html)
// in the Amazon RDS User Guide.
//
// This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora
// clusters, use StopDBCluster instead.
//
//    // Example sending a request using StopDBInstanceRequest.
//    req := client.StopDBInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBInstance
func (c *Client) StopDBInstanceRequest(input *StopDBInstanceInput) StopDBInstanceRequest {
	op := &aws.Operation{
		Name:       opStopDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDBInstanceInput{}
	}

	req := c.newRequest(op, input, &StopDBInstanceOutput{})

	return StopDBInstanceRequest{Request: req, Input: input, Copy: c.StopDBInstanceRequest}
}

// StopDBInstanceRequest is the request type for the
// StopDBInstance API operation.
type StopDBInstanceRequest struct {
	*aws.Request
	Input *StopDBInstanceInput
	Copy  func(*StopDBInstanceInput) StopDBInstanceRequest
}

// Send marshals and sends the StopDBInstance API request.
func (r StopDBInstanceRequest) Send(ctx context.Context) (*StopDBInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopDBInstanceResponse{
		StopDBInstanceOutput: r.Request.Data.(*StopDBInstanceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopDBInstanceResponse is the response type for the
// StopDBInstance API operation.
type StopDBInstanceResponse struct {
	*StopDBInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopDBInstance request.
func (r *StopDBInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
