// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CopyClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The number of days that a manual snapshot is retained. If the value is -1,
	// the manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	//
	// The default value is -1.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The identifier of the cluster the source snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints:
	//
	//    * Must be the identifier for a valid cluster.
	SourceSnapshotClusterIdentifier *string `type:"string"`

	// The identifier for the source snapshot.
	//
	// Constraints:
	//
	//    * Must be the identifier for a valid automated snapshot whose state is
	//    available.
	//
	// SourceSnapshotIdentifier is a required field
	SourceSnapshotIdentifier *string `type:"string" required:"true"`

	// The identifier given to the new manual snapshot.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank.
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for the AWS account that is making the request.
	//
	// TargetSnapshotIdentifier is a required field
	TargetSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyClusterSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CopyClusterSnapshotInput"}

	if s.SourceSnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceSnapshotIdentifier"))
	}

	if s.TargetSnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CopyClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CopyClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opCopyClusterSnapshot = "CopyClusterSnapshot"

// CopyClusterSnapshotRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Copies the specified automated cluster snapshot to a new manual cluster snapshot.
// The source must be an automated snapshot and it must be in the available
// state.
//
// When you delete a cluster, Amazon Redshift deletes any automated snapshots
// of the cluster. Also, when the retention period of the snapshot expires,
// Amazon Redshift automatically deletes it. If you want to keep an automated
// snapshot for a longer period, you can make a manual copy of the snapshot.
// Manual snapshots are retained until you delete them.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using CopyClusterSnapshotRequest.
//    req := client.CopyClusterSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot
func (c *Client) CopyClusterSnapshotRequest(input *CopyClusterSnapshotInput) CopyClusterSnapshotRequest {
	op := &aws.Operation{
		Name:       opCopyClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyClusterSnapshotInput{}
	}

	req := c.newRequest(op, input, &CopyClusterSnapshotOutput{})

	return CopyClusterSnapshotRequest{Request: req, Input: input, Copy: c.CopyClusterSnapshotRequest}
}

// CopyClusterSnapshotRequest is the request type for the
// CopyClusterSnapshot API operation.
type CopyClusterSnapshotRequest struct {
	*aws.Request
	Input *CopyClusterSnapshotInput
	Copy  func(*CopyClusterSnapshotInput) CopyClusterSnapshotRequest
}

// Send marshals and sends the CopyClusterSnapshot API request.
func (r CopyClusterSnapshotRequest) Send(ctx context.Context) (*CopyClusterSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CopyClusterSnapshotResponse{
		CopyClusterSnapshotOutput: r.Request.Data.(*CopyClusterSnapshotOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CopyClusterSnapshotResponse is the response type for the
// CopyClusterSnapshot API operation.
type CopyClusterSnapshotResponse struct {
	*CopyClusterSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CopyClusterSnapshot request.
func (r *CopyClusterSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
