// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The result of the CreateSnapshotCopyGrant action.
type CreateSnapshotCopyGrantInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the customer master key (CMK) to which to grant
	// Amazon Redshift permission. If no key is specified, the default key is used.
	KmsKeyId *string `type:"string"`

	// The name of the snapshot copy grant. This name must be unique in the region
	// for the AWS account.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * Alphabetic characters must be lowercase.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for all clusters within an AWS account.
	//
	// SnapshotCopyGrantName is a required field
	SnapshotCopyGrantName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateSnapshotCopyGrantInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotCopyGrantInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSnapshotCopyGrantInput"}

	if s.SnapshotCopyGrantName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotCopyGrantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateSnapshotCopyGrantOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot copy grant that grants Amazon Redshift permission to encrypt
	// copied snapshots with the specified customer master key (CMK) from AWS KMS
	// in the destination region.
	//
	// For more information about managing snapshot copy grants, go to Amazon Redshift
	// Database Encryption (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
	// in the Amazon Redshift Cluster Management Guide.
	SnapshotCopyGrant *SnapshotCopyGrant `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotCopyGrantOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateSnapshotCopyGrant = "CreateSnapshotCopyGrant"

// CreateSnapshotCopyGrantRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Creates a snapshot copy grant that permits Amazon Redshift to use a customer
// master key (CMK) from AWS Key Management Service (AWS KMS) to encrypt copied
// snapshots in a destination region.
//
// For more information about managing snapshot copy grants, go to Amazon Redshift
// Database Encryption (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using CreateSnapshotCopyGrantRequest.
//    req := client.CreateSnapshotCopyGrantRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant
func (c *Client) CreateSnapshotCopyGrantRequest(input *CreateSnapshotCopyGrantInput) CreateSnapshotCopyGrantRequest {
	op := &aws.Operation{
		Name:       opCreateSnapshotCopyGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotCopyGrantInput{}
	}

	req := c.newRequest(op, input, &CreateSnapshotCopyGrantOutput{})

	return CreateSnapshotCopyGrantRequest{Request: req, Input: input, Copy: c.CreateSnapshotCopyGrantRequest}
}

// CreateSnapshotCopyGrantRequest is the request type for the
// CreateSnapshotCopyGrant API operation.
type CreateSnapshotCopyGrantRequest struct {
	*aws.Request
	Input *CreateSnapshotCopyGrantInput
	Copy  func(*CreateSnapshotCopyGrantInput) CreateSnapshotCopyGrantRequest
}

// Send marshals and sends the CreateSnapshotCopyGrant API request.
func (r CreateSnapshotCopyGrantRequest) Send(ctx context.Context) (*CreateSnapshotCopyGrantResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSnapshotCopyGrantResponse{
		CreateSnapshotCopyGrantOutput: r.Request.Data.(*CreateSnapshotCopyGrantOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSnapshotCopyGrantResponse is the response type for the
// CreateSnapshotCopyGrant API operation.
type CreateSnapshotCopyGrantResponse struct {
	*CreateSnapshotCopyGrantOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSnapshotCopyGrant request.
func (r *CreateSnapshotCopyGrantResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
