// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateUsageLimitInput struct {
	_ struct{} `type:"structure"`

	// The limit amount. If time-based, this amount is in minutes. If data-based,
	// this amount is in terabytes (TB). The value must be a positive number.
	//
	// Amount is a required field
	Amount *int64 `type:"long" required:"true"`

	// The action that Amazon Redshift takes when the limit is reached. The default
	// is log. For more information about this parameter, see UsageLimit.
	BreachAction UsageLimitBreachAction `type:"string" enum:"true"`

	// The identifier of the cluster that you want to limit usage.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The Amazon Redshift feature that you want to limit.
	//
	// FeatureType is a required field
	FeatureType UsageLimitFeatureType `type:"string" required:"true" enum:"true"`

	// The type of limit. Depending on the feature type, this can be based on a
	// time duration or data size. If FeatureType is spectrum, then LimitType must
	// be data-scanned. If FeatureType is concurrency-scaling, then LimitType must
	// be time.
	//
	// LimitType is a required field
	LimitType UsageLimitLimitType `type:"string" required:"true" enum:"true"`

	// The time period that the amount applies to. A weekly period begins on Sunday.
	// The default is monthly.
	Period UsageLimitPeriod `type:"string" enum:"true"`

	// A list of tag instances.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateUsageLimitInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUsageLimitInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateUsageLimitInput"}

	if s.Amount == nil {
		invalidParams.Add(aws.NewErrParamRequired("Amount"))
	}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}
	if len(s.FeatureType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FeatureType"))
	}
	if len(s.LimitType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("LimitType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a usage limit object for a cluster.
type CreateUsageLimitOutput struct {
	_ struct{} `type:"structure"`

	// The limit amount. If time-based, this amount is in minutes. If data-based,
	// this amount is in terabytes (TB).
	Amount *int64 `type:"long"`

	// The action that Amazon Redshift takes when the limit is reached. Possible
	// values are:
	//
	//    * log - To log an event in a system table. The default is log.
	//
	//    * emit-metric - To emit CloudWatch metrics.
	//
	//    * disable - To disable the feature until the next usage period begins.
	BreachAction UsageLimitBreachAction `type:"string" enum:"true"`

	// The identifier of the cluster with a usage limit.
	ClusterIdentifier *string `type:"string"`

	// The Amazon Redshift feature to which the limit applies.
	FeatureType UsageLimitFeatureType `type:"string" enum:"true"`

	// The type of limit. Depending on the feature type, this can be based on a
	// time duration or data size.
	LimitType UsageLimitLimitType `type:"string" enum:"true"`

	// The time period that the amount applies to. A weekly period begins on Sunday.
	// The default is monthly.
	Period UsageLimitPeriod `type:"string" enum:"true"`

	// A list of tag instances.
	Tags []Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the usage limit.
	UsageLimitId *string `type:"string"`
}

// String returns the string representation
func (s CreateUsageLimitOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateUsageLimit = "CreateUsageLimit"

// CreateUsageLimitRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Creates a usage limit for a specified Amazon Redshift feature on a cluster.
// The usage limit is identified by the returned usage limit identifier.
//
//    // Example sending a request using CreateUsageLimitRequest.
//    req := client.CreateUsageLimitRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateUsageLimit
func (c *Client) CreateUsageLimitRequest(input *CreateUsageLimitInput) CreateUsageLimitRequest {
	op := &aws.Operation{
		Name:       opCreateUsageLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUsageLimitInput{}
	}

	req := c.newRequest(op, input, &CreateUsageLimitOutput{})

	return CreateUsageLimitRequest{Request: req, Input: input, Copy: c.CreateUsageLimitRequest}
}

// CreateUsageLimitRequest is the request type for the
// CreateUsageLimit API operation.
type CreateUsageLimitRequest struct {
	*aws.Request
	Input *CreateUsageLimitInput
	Copy  func(*CreateUsageLimitInput) CreateUsageLimitRequest
}

// Send marshals and sends the CreateUsageLimit API request.
func (r CreateUsageLimitRequest) Send(ctx context.Context) (*CreateUsageLimitResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateUsageLimitResponse{
		CreateUsageLimitOutput: r.Request.Data.(*CreateUsageLimitOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateUsageLimitResponse is the response type for the
// CreateUsageLimit API operation.
type CreateUsageLimitResponse struct {
	*CreateUsageLimitOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateUsageLimit request.
func (r *CreateUsageLimitResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
