// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeOrderableClusterOptionsInput struct {
	_ struct{} `type:"structure"`

	// The version filter value. Specify this parameter to show only the available
	// offerings matching the specified version.
	//
	// Default: All versions.
	//
	// Constraints: Must be one of the version returned from DescribeClusterVersions.
	ClusterVersion *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeOrderableClusterOptions request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The node type filter value. Specify this parameter to show only the available
	// offerings matching the specified node type.
	NodeType *string `type:"string"`
}

// String returns the string representation
func (s DescribeOrderableClusterOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output from the DescribeOrderableClusterOptions action.
type DescribeOrderableClusterOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// An OrderableClusterOption structure containing information about orderable
	// options for the cluster.
	OrderableClusterOptions []OrderableClusterOption `locationNameList:"OrderableClusterOption" type:"list"`
}

// String returns the string representation
func (s DescribeOrderableClusterOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeOrderableClusterOptions = "DescribeOrderableClusterOptions"

// DescribeOrderableClusterOptionsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns a list of orderable cluster options. Before you create a new cluster
// you can use this operation to find what options are available, such as the
// EC2 Availability Zones (AZ) in the specific AWS Region that you can specify,
// and the node types you can request. The node types differ by available storage,
// memory, CPU and price. With the cost involved you might want to obtain a
// list of cluster options in the specific region and specify values when creating
// a cluster. For more information about managing clusters, go to Amazon Redshift
// Clusters (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using DescribeOrderableClusterOptionsRequest.
//    req := client.DescribeOrderableClusterOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions
func (c *Client) DescribeOrderableClusterOptionsRequest(input *DescribeOrderableClusterOptionsInput) DescribeOrderableClusterOptionsRequest {
	op := &aws.Operation{
		Name:       opDescribeOrderableClusterOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableClusterOptionsInput{}
	}

	req := c.newRequest(op, input, &DescribeOrderableClusterOptionsOutput{})

	return DescribeOrderableClusterOptionsRequest{Request: req, Input: input, Copy: c.DescribeOrderableClusterOptionsRequest}
}

// DescribeOrderableClusterOptionsRequest is the request type for the
// DescribeOrderableClusterOptions API operation.
type DescribeOrderableClusterOptionsRequest struct {
	*aws.Request
	Input *DescribeOrderableClusterOptionsInput
	Copy  func(*DescribeOrderableClusterOptionsInput) DescribeOrderableClusterOptionsRequest
}

// Send marshals and sends the DescribeOrderableClusterOptions API request.
func (r DescribeOrderableClusterOptionsRequest) Send(ctx context.Context) (*DescribeOrderableClusterOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeOrderableClusterOptionsResponse{
		DescribeOrderableClusterOptionsOutput: r.Request.Data.(*DescribeOrderableClusterOptionsOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeOrderableClusterOptionsRequestPaginator returns a paginator for DescribeOrderableClusterOptions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeOrderableClusterOptionsRequest(input)
//   p := redshift.NewDescribeOrderableClusterOptionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeOrderableClusterOptionsPaginator(req DescribeOrderableClusterOptionsRequest) DescribeOrderableClusterOptionsPaginator {
	return DescribeOrderableClusterOptionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeOrderableClusterOptionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeOrderableClusterOptionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeOrderableClusterOptionsPaginator struct {
	aws.Pager
}

func (p *DescribeOrderableClusterOptionsPaginator) CurrentPage() *DescribeOrderableClusterOptionsOutput {
	return p.Pager.CurrentPage().(*DescribeOrderableClusterOptionsOutput)
}

// DescribeOrderableClusterOptionsResponse is the response type for the
// DescribeOrderableClusterOptions API operation.
type DescribeOrderableClusterOptionsResponse struct {
	*DescribeOrderableClusterOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeOrderableClusterOptions request.
func (r *DescribeOrderableClusterOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
