// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the marker
	// parameter and retrying the command. If the marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The maximum number or response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for which you want to describe the tag or
	// tags. For example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
	ResourceName *string `type:"string"`

	// The type of resource with which you want to view tags. Valid resource types
	// are:
	//
	//    * Cluster
	//
	//    * CIDR/IP
	//
	//    * EC2 security group
	//
	//    * Snapshot
	//
	//    * Cluster security group
	//
	//    * Subnet group
	//
	//    * HSM connection
	//
	//    * HSM certificate
	//
	//    * Parameter group
	//
	//    * Snapshot copy grant
	//
	// For more information about Amazon Redshift resource types and constructing
	// ARNs, go to Specifying Policy Elements: Actions, Effects, Resources, and
	// Principals (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions)
	// in the Amazon Redshift Cluster Management Guide.
	ResourceType *string `type:"string"`

	// A tag key or keys for which you want to return all matching resources that
	// are associated with the specified key or keys. For example, suppose that
	// you have resources tagged with keys called owner and environment. If you
	// specify both of these tag keys in the request, Amazon Redshift returns a
	// response with all resources that have either or both of these tag keys associated
	// with them.
	TagKeys []string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching resources
	// that are associated with the specified value or values. For example, suppose
	// that you have resources tagged with values called admin and test. If you
	// specify both of these tag values in the request, Amazon Redshift returns
	// a response with all resources that have either or both of these tag values
	// associated with them.
	TagValues []string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of tags with their associated resources.
	TaggedResources []TaggedResource `locationNameList:"TaggedResource" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns a list of tags. You can return tags from a specific resource by specifying
// an ARN, or you can return all tags for a given type of resource, such as
// clusters, snapshots, and so on.
//
// The following are limitations for DescribeTags:
//
//    * You cannot specify an ARN and a resource-type value together in the
//    same request.
//
//    * You cannot use the MaxRecords and Marker parameters together with the
//    ARN parameter.
//
//    * The MaxRecords parameter can be a range from 10 to 50 results to return
//    in a request.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all resources that match any combination of the specified keys and
// values. For example, if you have owner and environment for tag keys, and
// admin and test for tag values, all resources that have any combination of
// those values are returned.
//
// If both tag keys and values are omitted from the request, resources are returned
// regardless of whether they have tag keys or values associated with them.
//
//    // Example sending a request using DescribeTagsRequest.
//    req := client.DescribeTagsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags
func (c *Client) DescribeTagsRequest(input *DescribeTagsInput) DescribeTagsRequest {
	op := &aws.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req := c.newRequest(op, input, &DescribeTagsOutput{})

	return DescribeTagsRequest{Request: req, Input: input, Copy: c.DescribeTagsRequest}
}

// DescribeTagsRequest is the request type for the
// DescribeTags API operation.
type DescribeTagsRequest struct {
	*aws.Request
	Input *DescribeTagsInput
	Copy  func(*DescribeTagsInput) DescribeTagsRequest
}

// Send marshals and sends the DescribeTags API request.
func (r DescribeTagsRequest) Send(ctx context.Context) (*DescribeTagsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTagsResponse{
		DescribeTagsOutput: r.Request.Data.(*DescribeTagsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTagsResponse is the response type for the
// DescribeTags API operation.
type DescribeTagsResponse struct {
	*DescribeTagsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTags request.
func (r *DescribeTagsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
