// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request parameters to get cluster credentials.
type GetClusterCredentialsInput struct {
	_ struct{} `type:"structure"`

	// Create a database user with the name specified for the user named in DbUser
	// if one does not exist.
	AutoCreate *bool `type:"boolean"`

	// The unique identifier of the cluster that contains the database for which
	// your are requesting credentials. This parameter is case sensitive.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// A list of the names of existing database groups that the user named in DbUser
	// will join for the current session, in addition to any group memberships for
	// an existing user. If not specified, a new user is added only to PUBLIC.
	//
	// Database group name constraints
	//
	//    * Must be 1 to 64 alphanumeric characters or hyphens
	//
	//    * Must contain only lowercase letters, numbers, underscore, plus sign,
	//    period (dot), at symbol (@), or hyphen.
	//
	//    * First character must be a letter.
	//
	//    * Must not contain a colon ( : ) or slash ( / ).
	//
	//    * Cannot be a reserved word. A list of reserved words can be found in
	//    Reserved Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	DbGroups []string `locationNameList:"DbGroup" type:"list"`

	// The name of a database that DbUser is authorized to log on to. If DbName
	// is not specified, DbUser can log on to any existing database.
	//
	// Constraints:
	//
	//    * Must be 1 to 64 alphanumeric characters or hyphens
	//
	//    * Must contain only lowercase letters, numbers, underscore, plus sign,
	//    period (dot), at symbol (@), or hyphen.
	//
	//    * First character must be a letter.
	//
	//    * Must not contain a colon ( : ) or slash ( / ).
	//
	//    * Cannot be a reserved word. A list of reserved words can be found in
	//    Reserved Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	DbName *string `type:"string"`

	// The name of a database user. If a user name matching DbUser exists in the
	// database, the temporary user credentials have the same permissions as the
	// existing user. If DbUser doesn't exist in the database and Autocreate is
	// True, a new user is created using the value for DbUser with PUBLIC permissions.
	// If a database user matching the value for DbUser doesn't exist and Autocreate
	// is False, then the command succeeds but the connection attempt will fail
	// because the user doesn't exist in the database.
	//
	// For more information, see CREATE USER (https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html)
	// in the Amazon Redshift Database Developer Guide.
	//
	// Constraints:
	//
	//    * Must be 1 to 64 alphanumeric characters or hyphens. The user name can't
	//    be PUBLIC.
	//
	//    * Must contain only lowercase letters, numbers, underscore, plus sign,
	//    period (dot), at symbol (@), or hyphen.
	//
	//    * First character must be a letter.
	//
	//    * Must not contain a colon ( : ) or slash ( / ).
	//
	//    * Cannot be a reserved word. A list of reserved words can be found in
	//    Reserved Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	//
	// DbUser is a required field
	DbUser *string `type:"string" required:"true"`

	// The number of seconds until the returned temporary password expires.
	//
	// Constraint: minimum 900, maximum 3600.
	//
	// Default: 900
	DurationSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s GetClusterCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClusterCredentialsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetClusterCredentialsInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if s.DbUser == nil {
		invalidParams.Add(aws.NewErrParamRequired("DbUser"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Temporary credentials with authorization to log on to an Amazon Redshift
// database.
type GetClusterCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// A temporary password that authorizes the user name returned by DbUser to
	// log on to the database DbName.
	DbPassword *string `type:"string" sensitive:"true"`

	// A database user name that is authorized to log on to the database DbName
	// using the password DbPassword. If the specified DbUser exists in the database,
	// the new user name has the same database privileges as the the user named
	// in DbUser. By default, the user is added to PUBLIC. If the DbGroups parameter
	// is specifed, DbUser is added to the listed groups for any sessions created
	// using these credentials.
	DbUser *string `type:"string"`

	// The date and time the password in DbPassword expires.
	Expiration *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s GetClusterCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetClusterCredentials = "GetClusterCredentials"

// GetClusterCredentialsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns a database user name and temporary password with temporary authorization
// to log on to an Amazon Redshift database. The action returns the database
// user name prefixed with IAM: if AutoCreate is False or IAMA: if AutoCreate
// is True. You can optionally specify one or more database user groups that
// the user will join at log on. By default, the temporary credentials expire
// in 900 seconds. You can optionally specify a duration between 900 seconds
// (15 minutes) and 3600 seconds (60 minutes). For more information, see Using
// IAM Authentication to Generate Database User Credentials (https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html)
// in the Amazon Redshift Cluster Management Guide.
//
// The AWS Identity and Access Management (IAM)user or role that executes GetClusterCredentials
// must have an IAM policy attached that allows access to all necessary actions
// and resources. For more information about permissions, see Resource Policies
// for GetClusterCredentials (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources)
// in the Amazon Redshift Cluster Management Guide.
//
// If the DbGroups parameter is specified, the IAM policy must allow the redshift:JoinGroup
// action with access to the listed dbgroups.
//
// In addition, if the AutoCreate parameter is set to True, then the policy
// must include the redshift:CreateClusterUser privilege.
//
// If the DbName parameter is specified, the IAM policy must allow access to
// the resource dbname for the specified database name.
//
//    // Example sending a request using GetClusterCredentialsRequest.
//    req := client.GetClusterCredentialsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentials
func (c *Client) GetClusterCredentialsRequest(input *GetClusterCredentialsInput) GetClusterCredentialsRequest {
	op := &aws.Operation{
		Name:       opGetClusterCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetClusterCredentialsInput{}
	}

	req := c.newRequest(op, input, &GetClusterCredentialsOutput{})

	return GetClusterCredentialsRequest{Request: req, Input: input, Copy: c.GetClusterCredentialsRequest}
}

// GetClusterCredentialsRequest is the request type for the
// GetClusterCredentials API operation.
type GetClusterCredentialsRequest struct {
	*aws.Request
	Input *GetClusterCredentialsInput
	Copy  func(*GetClusterCredentialsInput) GetClusterCredentialsRequest
}

// Send marshals and sends the GetClusterCredentials API request.
func (r GetClusterCredentialsRequest) Send(ctx context.Context) (*GetClusterCredentialsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetClusterCredentialsResponse{
		GetClusterCredentialsOutput: r.Request.Data.(*GetClusterCredentialsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetClusterCredentialsResponse is the response type for the
// GetClusterCredentials API operation.
type GetClusterCredentialsResponse struct {
	*GetClusterCredentialsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetClusterCredentials request.
func (r *GetClusterCredentialsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
