// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyUsageLimitInput struct {
	_ struct{} `type:"structure"`

	// The new limit amount. For more information about this parameter, see UsageLimit.
	Amount *int64 `type:"long"`

	// The new action that Amazon Redshift takes when the limit is reached. For
	// more information about this parameter, see UsageLimit.
	BreachAction UsageLimitBreachAction `type:"string" enum:"true"`

	// The identifier of the usage limit to modify.
	//
	// UsageLimitId is a required field
	UsageLimitId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyUsageLimitInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyUsageLimitInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyUsageLimitInput"}

	if s.UsageLimitId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UsageLimitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a usage limit object for a cluster.
type ModifyUsageLimitOutput struct {
	_ struct{} `type:"structure"`

	// The limit amount. If time-based, this amount is in minutes. If data-based,
	// this amount is in terabytes (TB).
	Amount *int64 `type:"long"`

	// The action that Amazon Redshift takes when the limit is reached. Possible
	// values are:
	//
	//    * log - To log an event in a system table. The default is log.
	//
	//    * emit-metric - To emit CloudWatch metrics.
	//
	//    * disable - To disable the feature until the next usage period begins.
	BreachAction UsageLimitBreachAction `type:"string" enum:"true"`

	// The identifier of the cluster with a usage limit.
	ClusterIdentifier *string `type:"string"`

	// The Amazon Redshift feature to which the limit applies.
	FeatureType UsageLimitFeatureType `type:"string" enum:"true"`

	// The type of limit. Depending on the feature type, this can be based on a
	// time duration or data size.
	LimitType UsageLimitLimitType `type:"string" enum:"true"`

	// The time period that the amount applies to. A weekly period begins on Sunday.
	// The default is monthly.
	Period UsageLimitPeriod `type:"string" enum:"true"`

	// A list of tag instances.
	Tags []Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the usage limit.
	UsageLimitId *string `type:"string"`
}

// String returns the string representation
func (s ModifyUsageLimitOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyUsageLimit = "ModifyUsageLimit"

// ModifyUsageLimitRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Modifies a usage limit in a cluster. You can't modify the feature type or
// period of a usage limit.
//
//    // Example sending a request using ModifyUsageLimitRequest.
//    req := client.ModifyUsageLimitRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyUsageLimit
func (c *Client) ModifyUsageLimitRequest(input *ModifyUsageLimitInput) ModifyUsageLimitRequest {
	op := &aws.Operation{
		Name:       opModifyUsageLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyUsageLimitInput{}
	}

	req := c.newRequest(op, input, &ModifyUsageLimitOutput{})

	return ModifyUsageLimitRequest{Request: req, Input: input, Copy: c.ModifyUsageLimitRequest}
}

// ModifyUsageLimitRequest is the request type for the
// ModifyUsageLimit API operation.
type ModifyUsageLimitRequest struct {
	*aws.Request
	Input *ModifyUsageLimitInput
	Copy  func(*ModifyUsageLimitInput) ModifyUsageLimitRequest
}

// Send marshals and sends the ModifyUsageLimit API request.
func (r ModifyUsageLimitRequest) Send(ctx context.Context) (*ModifyUsageLimitResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyUsageLimitResponse{
		ModifyUsageLimitOutput: r.Request.Data.(*ModifyUsageLimitOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyUsageLimitResponse is the response type for the
// ModifyUsageLimit API operation.
type ModifyUsageLimitResponse struct {
	*ModifyUsageLimitOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyUsageLimit request.
func (r *ModifyUsageLimitResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
