// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PauseClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to be paused.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PauseClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PauseClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PauseClusterInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PauseClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s PauseClusterOutput) String() string {
	return awsutil.Prettify(s)
}

const opPauseCluster = "PauseCluster"

// PauseClusterRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Pauses a cluster.
//
//    // Example sending a request using PauseClusterRequest.
//    req := client.PauseClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PauseCluster
func (c *Client) PauseClusterRequest(input *PauseClusterInput) PauseClusterRequest {
	op := &aws.Operation{
		Name:       opPauseCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PauseClusterInput{}
	}

	req := c.newRequest(op, input, &PauseClusterOutput{})

	return PauseClusterRequest{Request: req, Input: input, Copy: c.PauseClusterRequest}
}

// PauseClusterRequest is the request type for the
// PauseCluster API operation.
type PauseClusterRequest struct {
	*aws.Request
	Input *PauseClusterInput
	Copy  func(*PauseClusterInput) PauseClusterRequest
}

// Send marshals and sends the PauseCluster API request.
func (r PauseClusterRequest) Send(ctx context.Context) (*PauseClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PauseClusterResponse{
		PauseClusterOutput: r.Request.Data.(*PauseClusterOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PauseClusterResponse is the response type for the
// PauseCluster API operation.
type PauseClusterResponse struct {
	*PauseClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PauseCluster request.
func (r *PauseClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
