// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RotateEncryptionKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster that you want to rotate the encryption
	// keys for.
	//
	// Constraints: Must be the name of valid cluster that has encryption enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RotateEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotateEncryptionKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RotateEncryptionKeyInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RotateEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RotateEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opRotateEncryptionKey = "RotateEncryptionKey"

// RotateEncryptionKeyRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Rotates the encryption keys for a cluster.
//
//    // Example sending a request using RotateEncryptionKeyRequest.
//    req := client.RotateEncryptionKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKey
func (c *Client) RotateEncryptionKeyRequest(input *RotateEncryptionKeyInput) RotateEncryptionKeyRequest {
	op := &aws.Operation{
		Name:       opRotateEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RotateEncryptionKeyInput{}
	}

	req := c.newRequest(op, input, &RotateEncryptionKeyOutput{})

	return RotateEncryptionKeyRequest{Request: req, Input: input, Copy: c.RotateEncryptionKeyRequest}
}

// RotateEncryptionKeyRequest is the request type for the
// RotateEncryptionKey API operation.
type RotateEncryptionKeyRequest struct {
	*aws.Request
	Input *RotateEncryptionKeyInput
	Copy  func(*RotateEncryptionKeyInput) RotateEncryptionKeyRequest
}

// Send marshals and sends the RotateEncryptionKey API request.
func (r RotateEncryptionKeyRequest) Send(ctx context.Context) (*RotateEncryptionKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RotateEncryptionKeyResponse{
		RotateEncryptionKeyOutput: r.Request.Data.(*RotateEncryptionKeyOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RotateEncryptionKeyResponse is the response type for the
// RotateEncryptionKey API operation.
type RotateEncryptionKeyResponse struct {
	*RotateEncryptionKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RotateEncryptionKey request.
func (r *RotateEncryptionKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
