// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// A name value pair that describes an aspect of an account.
type AccountAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	AttributeName *string `type:"string"`

	// A list of attribute values.
	AttributeValues []AttributeValueTarget `locationNameList:"AttributeValueTarget" type:"list"`
}

// String returns the string representation
func (s AccountAttribute) String() string {
	return awsutil.Prettify(s)
}

// Describes an AWS customer account authorized to restore a snapshot.
type AccountWithRestoreAccess struct {
	_ struct{} `type:"structure"`

	// The identifier of an AWS support account authorized to restore a snapshot.
	// For AWS support, the identifier is amazon-redshift-support.
	AccountAlias *string `type:"string"`

	// The identifier of an AWS customer account authorized to restore a snapshot.
	AccountId *string `type:"string"`
}

// String returns the string representation
func (s AccountWithRestoreAccess) String() string {
	return awsutil.Prettify(s)
}

// Describes an attribute value.
type AttributeValueTarget struct {
	_ struct{} `type:"structure"`

	// The value of the attribute.
	AttributeValue *string `type:"string"`
}

// String returns the string representation
func (s AttributeValueTarget) String() string {
	return awsutil.Prettify(s)
}

// Describes an availability zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`

	SupportedPlatforms []SupportedPlatform `locationNameList:"SupportedPlatform" type:"list"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// Describes a cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// A boolean value that, if true, indicates that major version upgrades will
	// be applied automatically to the cluster during the maintenance window.
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automatic cluster snapshots are retained.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The name of the Availability Zone in which the cluster is located.
	AvailabilityZone *string `type:"string"`

	// The availability status of the cluster for queries. Possible values are the
	// following:
	//
	//    * Available - The cluster is available for queries.
	//
	//    * Unavailable - The cluster is not available for queries.
	//
	//    * Maintenance - The cluster is intermittently available for queries due
	//    to maintenance activities.
	//
	//    * Modifying - The cluster is intermittently available for queries due
	//    to changes that modify the cluster.
	//
	//    * Failed - The cluster failed and is not available for queries.
	ClusterAvailabilityStatus *string `type:"string"`

	// The date and time that the cluster was created.
	ClusterCreateTime *time.Time `type:"timestamp"`

	// The unique identifier of the cluster.
	ClusterIdentifier *string `type:"string"`

	// The nodes in the cluster.
	ClusterNodes []ClusterNode `type:"list"`

	// The list of cluster parameter groups that are associated with this cluster.
	// Each parameter group in the list is returned with its status.
	ClusterParameterGroups []ClusterParameterGroupStatus `locationNameList:"ClusterParameterGroup" type:"list"`

	// The public key for the cluster.
	ClusterPublicKey *string `type:"string"`

	// The specific revision number of the database in the cluster.
	ClusterRevisionNumber *string `type:"string"`

	// A list of cluster security group that are associated with the cluster. Each
	// security group is represented by an element that contains ClusterSecurityGroup.Name
	// and ClusterSecurityGroup.Status subelements.
	//
	// Cluster security groups are used when the cluster is not created in an Amazon
	// Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security
	// groups, which are listed by the VpcSecurityGroups parameter.
	ClusterSecurityGroups []ClusterSecurityGroupMembership `locationNameList:"ClusterSecurityGroup" type:"list"`

	// A value that returns the destination region and retention period that are
	// configured for cross-region snapshot copy.
	ClusterSnapshotCopyStatus *ClusterSnapshotCopyStatus `type:"structure"`

	// The current state of the cluster. Possible values are the following:
	//
	//    * available
	//
	//    * available, prep-for-resize
	//
	//    * available, resize-cleanup
	//
	//    * cancelling-resize
	//
	//    * creating
	//
	//    * deleting
	//
	//    * final-snapshot
	//
	//    * hardware-failure
	//
	//    * incompatible-hsm
	//
	//    * incompatible-network
	//
	//    * incompatible-parameters
	//
	//    * incompatible-restore
	//
	//    * modifying
	//
	//    * paused
	//
	//    * rebooting
	//
	//    * renaming
	//
	//    * resizing
	//
	//    * rotating-keys
	//
	//    * storage-full
	//
	//    * updating-hsm
	ClusterStatus *string `type:"string"`

	// The name of the subnet group that is associated with the cluster. This parameter
	// is valid only when the cluster is in a VPC.
	ClusterSubnetGroupName *string `type:"string"`

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string `type:"string"`

	// The name of the initial database that was created when the cluster was created.
	// This same name is returned for the life of the cluster. If an initial database
	// was not specified, a database named devdev was created by default.
	DBName *string `type:"string"`

	// Describes the status of a cluster while it is in the process of resizing
	// with an incremental resize.
	DataTransferProgress *DataTransferProgress `type:"structure"`

	// Describes a group of DeferredMaintenanceWindow objects.
	DeferredMaintenanceWindows []DeferredMaintenanceWindow `locationNameList:"DeferredMaintenanceWindow" type:"list"`

	// The status of the elastic IP (EIP) address.
	ElasticIpStatus *ElasticIpStatus `type:"structure"`

	// The number of nodes that you can resize the cluster to with the elastic resize
	// method.
	ElasticResizeNumberOfNodeOptions *string `type:"string"`

	// A boolean value that, if true, indicates that data in the cluster is encrypted
	// at rest.
	Encrypted *bool `type:"boolean"`

	// The connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// The date and time when the next snapshot is expected to be taken for clusters
	// with a valid snapshot schedule and backups enabled.
	ExpectedNextSnapshotScheduleTime *time.Time `type:"timestamp"`

	// The status of next expected snapshot for clusters having a valid snapshot
	// schedule and backups enabled. Possible values are the following:
	//
	//    * OnTrack - The next snapshot is expected to be taken on time.
	//
	//    * Pending - The next snapshot is pending to be taken.
	ExpectedNextSnapshotScheduleTimeStatus *string `type:"string"`

	// A value that reports whether the Amazon Redshift cluster has finished applying
	// any hardware security module (HSM) settings changes specified in a modify
	// cluster command.
	//
	// Values: active, applying
	HsmStatus *HsmStatus `type:"structure"`

	// A list of AWS Identity and Access Management (IAM) roles that can be used
	// by the cluster to access other AWS services.
	IamRoles []ClusterIamRole `locationNameList:"ClusterIamRole" type:"list"`

	// The AWS Key Management Service (AWS KMS) key ID of the encryption key used
	// to encrypt data in the cluster.
	KmsKeyId *string `type:"string"`

	// The name of the maintenance track for the cluster.
	MaintenanceTrackName *string `type:"string"`

	// The default number of days to retain a manual snapshot. If the value is -1,
	// the snapshot is retained indefinitely. This setting doesn't change the retention
	// period of existing snapshots.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The master user name for the cluster. This name is used to connect to the
	// database that is specified in the DBName parameter.
	MasterUsername *string `type:"string"`

	// The status of a modify operation, if any, initiated for the cluster.
	ModifyStatus *string `type:"string"`

	// The date and time in UTC when system maintenance can begin.
	NextMaintenanceWindowStartTime *time.Time `type:"timestamp"`

	// The node type for the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of compute nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// Cluster operations that are waiting to be started.
	PendingActions []string `type:"list"`

	// A value that, if present, indicates that changes to the cluster are pending.
	// Specific pending changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// The weekly time range, in Universal Coordinated Time (UTC), during which
	// system maintenance can occur.
	PreferredMaintenanceWindow *string `type:"string"`

	// A boolean value that, if true, indicates that the cluster can be accessed
	// from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// Returns the following:
	//
	//    * AllowCancelResize: a boolean value indicating if the resize operation
	//    can be cancelled.
	//
	//    * ResizeType: Returns ClassicResize
	ResizeInfo *ResizeInfo `type:"structure"`

	// A value that describes the status of a cluster restore action. This parameter
	// returns null if the cluster was not created by restoring a snapshot.
	RestoreStatus *RestoreStatus `type:"structure"`

	// A unique identifier for the cluster snapshot schedule.
	SnapshotScheduleIdentifier *string `type:"string"`

	// The current state of the cluster snapshot schedule.
	SnapshotScheduleState ScheduleState `type:"string" enum:"true"`

	// The list of tags for the cluster.
	Tags []Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the VPC the cluster is in, if the cluster is in a VPC.
	VpcId *string `type:"string"`

	// A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that
	// are associated with the cluster. This parameter is returned only if the cluster
	// is in a VPC.
	VpcSecurityGroups []VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroup" type:"list"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

type ClusterAssociatedToSchedule struct {
	_ struct{} `type:"structure"`

	ClusterIdentifier *string `type:"string"`

	ScheduleAssociationState ScheduleState `type:"string" enum:"true"`
}

// String returns the string representation
func (s ClusterAssociatedToSchedule) String() string {
	return awsutil.Prettify(s)
}

// Describes a ClusterDbRevision.
type ClusterDbRevision struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster.
	ClusterIdentifier *string `type:"string"`

	// A string representing the current cluster version.
	CurrentDatabaseRevision *string `type:"string"`

	// The date on which the database revision was released.
	DatabaseRevisionReleaseDate *time.Time `type:"timestamp"`

	// A list of RevisionTarget objects, where each object describes the database
	// revision that a cluster can be updated to.
	RevisionTargets []RevisionTarget `locationNameList:"RevisionTarget" type:"list"`
}

// String returns the string representation
func (s ClusterDbRevision) String() string {
	return awsutil.Prettify(s)
}

// An AWS Identity and Access Management (IAM) role that can be used by the
// associated Amazon Redshift cluster to access other AWS services.
type ClusterIamRole struct {
	_ struct{} `type:"structure"`

	// A value that describes the status of the IAM role's association with an Amazon
	// Redshift cluster.
	//
	// The following are possible statuses and descriptions.
	//
	//    * in-sync: The role is available for use by the cluster.
	//
	//    * adding: The role is in the process of being associated with the cluster.
	//
	//    * removing: The role is in the process of being disassociated with the
	//    cluster.
	ApplyStatus *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role, for example, arn:aws:iam::123456789012:role/RedshiftCopyUnload.
	IamRoleArn *string `type:"string"`
}

// String returns the string representation
func (s ClusterIamRole) String() string {
	return awsutil.Prettify(s)
}

// The identifier of a node in a cluster.
type ClusterNode struct {
	_ struct{} `type:"structure"`

	// Whether the node is a leader node or a compute node.
	NodeRole *string `type:"string"`

	// The private IP address of a node within a cluster.
	PrivateIPAddress *string `type:"string"`

	// The public IP address of a node within a cluster.
	PublicIPAddress *string `type:"string"`
}

// String returns the string representation
func (s ClusterNode) String() string {
	return awsutil.Prettify(s)
}

// Describes a parameter group.
type ClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The description of the parameter group.
	Description *string `type:"string"`

	// The name of the cluster parameter group family that this cluster parameter
	// group is compatible with.
	ParameterGroupFamily *string `type:"string"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`

	// The list of tags for the cluster parameter group.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a parameter group.
type ClusterParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The list of parameter statuses.
	//
	// For more information about parameters and parameter groups, go to Amazon
	// Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ClusterParameterStatusList []ClusterParameterStatus `type:"list"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a parameter group.
type ClusterParameterStatus struct {
	_ struct{} `type:"structure"`

	// The error that prevented the parameter from being applied to the database.
	ParameterApplyErrorDescription *string `type:"string"`

	// The status of the parameter that indicates whether the parameter is in sync
	// with the database, waiting for a cluster reboot, or encountered an error
	// when being applied.
	//
	// The following are possible statuses and descriptions.
	//
	//    * in-sync: The parameter value is in sync with the database.
	//
	//    * pending-reboot: The parameter value will be applied after the cluster
	//    reboots.
	//
	//    * applying: The parameter value is being applied to the database.
	//
	//    * invalid-parameter: Cannot apply the parameter value because it has an
	//    invalid value or syntax.
	//
	//    * apply-deferred: The parameter contains static property changes. The
	//    changes are deferred until the cluster reboots.
	//
	//    * apply-error: Cannot connect to the cluster. The parameter change will
	//    be applied after the cluster reboots.
	//
	//    * unknown-error: Cannot apply the parameter change right now. The change
	//    will be applied after the cluster reboots.
	ParameterApplyStatus *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a security group.
type ClusterSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group to which the operation was applied.
	ClusterSecurityGroupName *string `type:"string"`

	// A description of the security group.
	Description *string `type:"string"`

	// A list of EC2 security groups that are permitted to access clusters associated
	// with this cluster security group.
	EC2SecurityGroups []EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// A list of IP ranges (CIDR blocks) that are permitted to access clusters associated
	// with this cluster security group.
	IPRanges []IPRange `locationNameList:"IPRange" type:"list"`

	// The list of tags for the cluster security group.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ClusterSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes a cluster security group.
type ClusterSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group.
	ClusterSecurityGroupName *string `type:"string"`

	// The status of the cluster security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ClusterSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// Returns the destination region and retention period that are configured for
// cross-region snapshot copy.
type ClusterSnapshotCopyStatus struct {
	_ struct{} `type:"structure"`

	// The destination region that snapshots are automatically copied to when cross-region
	// snapshot copy is enabled.
	DestinationRegion *string `type:"string"`

	// The number of days that automated snapshots are retained in the destination
	// region after they are copied from a source region. If the value is -1, the
	// manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The number of days that automated snapshots are retained in the destination
	// region after they are copied from a source region.
	RetentionPeriod *int64 `type:"long"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`
}

// String returns the string representation
func (s ClusterSnapshotCopyStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a subnet group.
type ClusterSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group.
	ClusterSubnetGroupName *string `type:"string"`

	// The description of the cluster subnet group.
	Description *string `type:"string"`

	// The status of the cluster subnet group. Possible values are Complete, Incomplete
	// and Invalid.
	SubnetGroupStatus *string `type:"string"`

	// A list of the VPC Subnet elements.
	Subnets []Subnet `locationNameList:"Subnet" type:"list"`

	// The list of tags for the cluster subnet group.
	Tags []Tag `locationNameList:"Tag" type:"list"`

	// The VPC ID of the cluster subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ClusterSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes a cluster version, including the parameter group family and description
// of the version.
type ClusterVersion struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group family for the cluster.
	ClusterParameterGroupFamily *string `type:"string"`

	// The version number used by the cluster.
	ClusterVersion *string `type:"string"`

	// The description of the cluster version.
	Description *string `type:"string"`
}

// String returns the string representation
func (s ClusterVersion) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a cluster while it is in the process of resizing
// with an incremental resize.
type DataTransferProgress struct {
	_ struct{} `type:"structure"`

	// Describes the data transfer rate in MB's per second.
	CurrentRateInMegaBytesPerSecond *float64 `type:"double"`

	// Describes the total amount of data that has been transfered in MB's.
	DataTransferredInMegaBytes *int64 `type:"long"`

	// Describes the number of seconds that have elapsed during the data transfer.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// Describes the estimated number of seconds remaining to complete the transfer.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// Describes the status of the cluster. While the transfer is in progress the
	// status is transferringdata.
	Status *string `type:"string"`

	// Describes the total amount of data to be transfered in megabytes.
	TotalDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DataTransferProgress) String() string {
	return awsutil.Prettify(s)
}

// Describes the default cluster parameters for a parameter group family.
type DefaultClusterParameters struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The name of the cluster parameter group family to which the engine default
	// parameters apply.
	ParameterGroupFamily *string `type:"string"`

	// The list of cluster default parameters.
	Parameters []Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DefaultClusterParameters) String() string {
	return awsutil.Prettify(s)
}

// Describes a deferred maintenance window
type DeferredMaintenanceWindow struct {
	_ struct{} `type:"structure"`

	// A timestamp for the end of the time period when we defer maintenance.
	DeferMaintenanceEndTime *time.Time `type:"timestamp"`

	// A unique identifier for the maintenance window.
	DeferMaintenanceIdentifier *string `type:"string"`

	// A timestamp for the beginning of the time period when we defer maintenance.
	DeferMaintenanceStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DeferredMaintenanceWindow) String() string {
	return awsutil.Prettify(s)
}

type DeleteClusterSnapshotMessage struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster the snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints: Must be the name of valid cluster.
	SnapshotClusterIdentifier *string `type:"string"`

	// The unique identifier of the manual snapshot to be deleted.
	//
	// Constraints: Must be the name of an existing snapshot that is in the available,
	// failed, or cancelled state.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSnapshotMessage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSnapshotMessage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteClusterSnapshotMessage"}

	if s.SnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an Amazon EC2 security group.
type EC2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the EC2 Security Group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS ID of the owner of the EC2 security group specified in the EC2SecurityGroupName
	// field.
	EC2SecurityGroupOwnerId *string `type:"string"`

	// The status of the EC2 security group.
	Status *string `type:"string"`

	// The list of tags for the EC2 security group.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of the elastic IP (EIP) address.
type ElasticIpStatus struct {
	_ struct{} `type:"structure"`

	// The elastic IP (EIP) address for the cluster.
	ElasticIp *string `type:"string"`

	// The status of the elastic IP (EIP) address.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ElasticIpStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a connection endpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The DNS address of the Cluster.
	Address *string `type:"string"`

	// The port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// Describes an event.
type Event struct {
	_ struct{} `type:"structure"`

	// The date and time of the event.
	Date *time.Time `type:"timestamp"`

	// A list of the event categories.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategories []string `locationNameList:"EventCategory" type:"list"`

	// The identifier of the event.
	EventId *string `type:"string"`

	// The text of this event.
	Message *string `type:"string"`

	// The severity of the event.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// The source type for this event.
	SourceType SourceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// Describes event categories.
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The events in the event category.
	Events []EventInfoMap `locationNameList:"EventInfoMap" type:"list"`

	// The source type, such as cluster or cluster-snapshot, that the returned categories
	// belong to.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// Describes event information.
type EventInfoMap struct {
	_ struct{} `type:"structure"`

	// The category of an Amazon Redshift event.
	EventCategories []string `locationNameList:"EventCategory" type:"list"`

	// The description of an Amazon Redshift event.
	EventDescription *string `type:"string"`

	// The identifier of an Amazon Redshift event.
	EventId *string `type:"string"`

	// The severity of the event.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`
}

// String returns the string representation
func (s EventInfoMap) String() string {
	return awsutil.Prettify(s)
}

// Describes event subscriptions.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Redshift event notification subscription.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the Amazon Redshift event notification
	// subscription.
	CustomerAwsId *string `type:"string"`

	// A boolean value indicating whether the subscription is enabled; true indicates
	// that the subscription is enabled.
	Enabled *bool `type:"boolean"`

	// The list of Amazon Redshift event categories specified in the event notification
	// subscription.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategoriesList []string `locationNameList:"EventCategory" type:"list"`

	// The event severity specified in the Amazon Redshift event notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event
	// notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of the sources that publish events to the Amazon Redshift event notification
	// subscription.
	SourceIdsList []string `locationNameList:"SourceId" type:"list"`

	// The source type of the events returned by the Amazon Redshift event notification,
	// such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group,
	// or scheduled-action.
	SourceType *string `type:"string"`

	// The status of the Amazon Redshift event notification subscription.
	//
	// Constraints:
	//
	//    * Can be one of the following: active | no-permission | topic-not-exist
	//
	//    * The status "no-permission" indicates that Amazon Redshift no longer
	//    has permission to post to the Amazon SNS topic. The status "topic-not-exist"
	//    indicates that the topic was deleted after the subscription was created.
	Status *string `type:"string"`

	// The date and time the Amazon Redshift event notification subscription was
	// created.
	SubscriptionCreationTime *time.Time `type:"timestamp"`

	// The list of tags for the event subscription.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// Returns information about an HSM client certificate. The certificate is stored
// in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift
// cluster to encrypt data files.
type HsmClientCertificate struct {
	_ struct{} `type:"structure"`

	// The identifier of the HSM client certificate.
	HsmClientCertificateIdentifier *string `type:"string"`

	// The public key that the Amazon Redshift cluster will use to connect to the
	// HSM. You must register the public key in the HSM.
	HsmClientCertificatePublicKey *string `type:"string"`

	// The list of tags for the HSM client certificate.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s HsmClientCertificate) String() string {
	return awsutil.Prettify(s)
}

// Returns information about an HSM configuration, which is an object that describes
// to Amazon Redshift clusters the information they require to connect to an
// HSM where they can store database encryption keys.
type HsmConfiguration struct {
	_ struct{} `type:"structure"`

	// A text description of the HSM configuration.
	Description *string `type:"string"`

	// The name of the Amazon Redshift HSM configuration.
	HsmConfigurationIdentifier *string `type:"string"`

	// The IP address that the Amazon Redshift cluster must use to access the HSM.
	HsmIpAddress *string `type:"string"`

	// The name of the partition in the HSM where the Amazon Redshift clusters will
	// store their database encryption keys.
	HsmPartitionName *string `type:"string"`

	// The list of tags for the HSM configuration.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s HsmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of changes to HSM settings.
type HsmStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// Reports whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command.
	//
	// Values: active, applying
	Status *string `type:"string"`
}

// String returns the string representation
func (s HsmStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes an IP range used in a security group.
type IPRange struct {
	_ struct{} `type:"structure"`

	// The IP range in Classless Inter-Domain Routing (CIDR) notation.
	CIDRIP *string `type:"string"`

	// The status of the IP range, for example, "authorized".
	Status *string `type:"string"`

	// The list of tags for the IP range.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s IPRange) String() string {
	return awsutil.Prettify(s)
}

// Defines a maintenance track that determines which Amazon Redshift version
// to apply during a maintenance window. If the value for MaintenanceTrack is
// current, the cluster is updated to the most recently certified maintenance
// release. If the value is trailing, the cluster is updated to the previously
// certified maintenance release.
type MaintenanceTrack struct {
	_ struct{} `type:"structure"`

	// The version number for the cluster release.
	DatabaseVersion *string `type:"string"`

	// The name of the maintenance track. Possible values are current and trailing.
	MaintenanceTrackName *string `type:"string"`

	// An array of UpdateTarget objects to update with the maintenance track.
	UpdateTargets []UpdateTarget `locationNameList:"UpdateTarget" type:"list"`
}

// String returns the string representation
func (s MaintenanceTrack) String() string {
	return awsutil.Prettify(s)
}

// A list of node configurations.
type NodeConfigurationOption struct {
	_ struct{} `type:"structure"`

	// The estimated disk utilizaton percentage.
	EstimatedDiskUtilizationPercent *float64 `type:"double"`

	// The category of the node configuration recommendation.
	Mode Mode `type:"string" enum:"true"`

	// The node type, such as, "ds2.8xlarge".
	NodeType *string `type:"string"`

	// The number of nodes.
	NumberOfNodes *int64 `type:"integer"`
}

// String returns the string representation
func (s NodeConfigurationOption) String() string {
	return awsutil.Prettify(s)
}

// A set of elements to filter the returned node configurations.
type NodeConfigurationOptionsFilter struct {
	_ struct{} `type:"structure"`

	// The name of the element to filter.
	Name NodeConfigurationOptionsFilterName `type:"string" enum:"true"`

	// The filter operator. If filter Name is NodeType only the 'in' operator is
	// supported. Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and
	// 'ge'. Provide two values to evaluate for 'between'. Provide a list of values
	// for 'in'.
	Operator OperatorType `type:"string" enum:"true"`

	// List of values. Compare Name using Operator to Values. If filter Name is
	// NumberOfNodes, then values can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent,
	// then values can range from 0 to 100. For example, filter NumberOfNodes (name)
	// GT (operator) 3 (values).
	Values []string `locationName:"Value" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s NodeConfigurationOptionsFilter) String() string {
	return awsutil.Prettify(s)
}

// Describes an orderable cluster option.
type OrderableClusterOption struct {
	_ struct{} `type:"structure"`

	// A list of availability zones for the orderable cluster.
	AvailabilityZones []AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The cluster type, for example multi-node.
	ClusterType *string `type:"string"`

	// The version of the orderable cluster.
	ClusterVersion *string `type:"string"`

	// The node type for the orderable cluster.
	NodeType *string `type:"string"`
}

// String returns the string representation
func (s OrderableClusterOption) String() string {
	return awsutil.Prettify(s)
}

// Describes a parameter in a cluster parameter group.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Specifies how to apply the WLM configuration parameter. Some properties can
	// be applied dynamically, while other properties require that any associated
	// clusters be rebooted for the configuration changes to be applied. For more
	// information about parameters and parameter groups, go to Amazon Redshift
	// Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ApplyType ParameterApplyType `type:"string" enum:"true"`

	// The data type of the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// If true, the parameter can be modified. Some parameters have security or
	// operational implications that prevent them from being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`

	// The source of the parameter value, such as "engine-default" or "user".
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

type PauseClusterMessage struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to be paused.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PauseClusterMessage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PauseClusterMessage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PauseClusterMessage"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes cluster attributes that are in a pending state. A change to one
// or more the attributes was requested and is in progress or will be applied.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The pending or in-progress change of the automated snapshot retention period.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The pending or in-progress change of the new identifier for the cluster.
	ClusterIdentifier *string `type:"string"`

	// The pending or in-progress change of the cluster type.
	ClusterType *string `type:"string"`

	// The pending or in-progress change of the service version.
	ClusterVersion *string `type:"string"`

	// The encryption type for a cluster. Possible values are: KMS and None. For
	// the China region the possible values are None, and Legacy.
	EncryptionType *string `type:"string"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// The name of the maintenance track that the cluster will change to during
	// the next maintenance window.
	MaintenanceTrackName *string `type:"string"`

	// The pending or in-progress change of the master user password for the cluster.
	MasterUserPassword *string `type:"string"`

	// The pending or in-progress change of the cluster's node type.
	NodeType *string `type:"string"`

	// The pending or in-progress change of the number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// The pending or in-progress change of the ability to connect to the cluster
	// from the public network.
	PubliclyAccessible *bool `type:"boolean"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// Describes a recurring charge.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The amount charged per the period of time specified by the recurring charge
	// frequency.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency at which the recurring charge amount is applied.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// Describes a reserved node. You can call the DescribeReservedNodeOfferings
// API to obtain the available reserved node offerings.
type ReservedNode struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved cluster.
	CurrencyCode *string `type:"string"`

	// The duration of the node reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed cost Amazon Redshift charges you for this reserved node.
	FixedPrice *float64 `type:"double"`

	// The number of reserved compute nodes.
	NodeCount *int64 `type:"integer"`

	// The node type of the reserved node.
	NodeType *string `type:"string"`

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string `type:"string"`

	// The recurring charges for the reserved node.
	RecurringCharges []RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The unique identifier for the reservation.
	ReservedNodeId *string `type:"string"`

	// The identifier for the reserved node offering.
	ReservedNodeOfferingId *string `type:"string"`

	ReservedNodeOfferingType ReservedNodeOfferingType `type:"string" enum:"true"`

	// The time the reservation started. You purchase a reserved node offering for
	// a duration. This is the start time of that duration.
	StartTime *time.Time `type:"timestamp"`

	// The state of the reserved compute node.
	//
	// Possible Values:
	//
	//    * pending-payment-This reserved node has recently been purchased, and
	//    the sale has been approved, but payment has not yet been confirmed.
	//
	//    * active-This reserved node is owned by the caller and is available for
	//    use.
	//
	//    * payment-failed-Payment failed for the purchase attempt.
	//
	//    * retired-The reserved node is no longer available.
	//
	//    * exchanging-The owner is exchanging the reserved node for another reserved
	//    node.
	State *string `type:"string"`

	// The hourly rate Amazon Redshift charges you for this reserved node.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedNode) String() string {
	return awsutil.Prettify(s)
}

// Describes a reserved node offering.
type ReservedNodeOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the compute nodes offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the offering will reserve the node.
	Duration *int64 `type:"integer"`

	// The upfront fixed charge you will pay to purchase the specific reserved node
	// offering.
	FixedPrice *float64 `type:"double"`

	// The node type offered by the reserved node offering.
	NodeType *string `type:"string"`

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string `type:"string"`

	// The charge to your account regardless of whether you are creating any clusters
	// using the node offering. Recurring charges are only in effect for heavy-utilization
	// reserved nodes.
	RecurringCharges []RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The offering identifier.
	ReservedNodeOfferingId *string `type:"string"`

	ReservedNodeOfferingType ReservedNodeOfferingType `type:"string" enum:"true"`

	// The rate you are charged for each hour the cluster that is using the offering
	// is running.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedNodeOffering) String() string {
	return awsutil.Prettify(s)
}

type ResizeClusterMessage struct {
	_ struct{} `type:"structure"`

	// A boolean value indicating whether the resize operation is using the classic
	// resize process. If you don't provide this parameter or set the value to false,
	// the resize type is elastic.
	Classic *bool `type:"boolean"`

	// The unique identifier for the cluster to resize.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The new cluster type for the specified cluster.
	ClusterType *string `type:"string"`

	// The new node type for the nodes you are adding. If not specified, the cluster's
	// current node type is used.
	NodeType *string `type:"string"`

	// The new number of nodes for the cluster.
	NumberOfNodes *int64 `type:"integer"`
}

// String returns the string representation
func (s ResizeClusterMessage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResizeClusterMessage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResizeClusterMessage"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a resize operation.
type ResizeInfo struct {
	_ struct{} `type:"structure"`

	// A boolean value indicating if the resize operation can be cancelled.
	AllowCancelResize *bool `type:"boolean"`

	// Returns the value ClassicResize.
	ResizeType *string `type:"string"`
}

// String returns the string representation
func (s ResizeInfo) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a cluster restore action. Returns null if the cluster
// was not created by restoring a snapshot.
type RestoreStatus struct {
	_ struct{} `type:"structure"`

	// The number of megabytes per second being transferred from the backup storage.
	// Returns the average rate for a completed backup. This field is only updated
	// when you restore to DC2 and DS2 node types.
	CurrentRestoreRateInMegaBytesPerSecond *float64 `type:"double"`

	// The amount of time an in-progress restore has been running, or the amount
	// of time it took a completed restore to finish. This field is only updated
	// when you restore to DC2 and DS2 node types.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimate of the time remaining before the restore will complete. Returns
	// 0 for a completed restore. This field is only updated when you restore to
	// DC2 and DS2 node types.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The number of megabytes that have been transferred from snapshot storage.
	// This field is only updated when you restore to DC2 and DS2 node types.
	ProgressInMegaBytes *int64 `type:"long"`

	// The size of the set of snapshot data used to restore the cluster. This field
	// is only updated when you restore to DC2 and DS2 node types.
	SnapshotSizeInMegaBytes *int64 `type:"long"`

	// The status of the restore action. Returns starting, restoring, completed,
	// or failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s RestoreStatus) String() string {
	return awsutil.Prettify(s)
}

type ResumeClusterMessage struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to be resumed.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResumeClusterMessage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResumeClusterMessage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResumeClusterMessage"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a RevisionTarget.
type RevisionTarget struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the version to update the cluster to. You
	// can use this value in ModifyClusterDbRevision.
	DatabaseRevision *string `type:"string"`

	// The date on which the database revision was released.
	DatabaseRevisionReleaseDate *time.Time `type:"timestamp"`

	// A string that describes the changes and features that will be applied to
	// the cluster when it is updated to the corresponding ClusterDbRevision.
	Description *string `type:"string"`
}

// String returns the string representation
func (s RevisionTarget) String() string {
	return awsutil.Prettify(s)
}

// Describes a scheduled action. You can use a scheduled action to trigger some
// Amazon Redshift API operations on a schedule. For information about which
// API operations can be scheduled, see ScheduledActionType.
type ScheduledAction struct {
	_ struct{} `type:"structure"`

	// The end time in UTC when the schedule is no longer active. After this time,
	// the scheduled action does not trigger.
	EndTime *time.Time `type:"timestamp"`

	// The IAM role to assume to run the scheduled action. This IAM role must have
	// permission to run the Amazon Redshift API operation in the scheduled action.
	// This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com)
	// to assume permissions on your behalf. For more information about the IAM
	// role to use with the Amazon Redshift scheduler, see Using Identity-Based
	// Policies for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Cluster Management Guide.
	IamRole *string `type:"string"`

	// List of times when the scheduled action will run.
	NextInvocations []time.Time `locationNameList:"ScheduledActionTime" type:"list"`

	// The schedule for a one-time (at format) or recurring (cron format) scheduled
	// action. Schedule invocations must be separated by at least one hour.
	//
	// Format of at expressions is "at(yyyy-mm-ddThh:mm:ss)". For example, "at(2016-03-04T17:27:00)".
	//
	// Format of cron expressions is "cron(Minutes Hours Day-of-month Month Day-of-week
	// Year)". For example, "cron(0 10 ? * MON *)". For more information, see Cron
	// Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Schedule *string `type:"string"`

	// The description of the scheduled action.
	ScheduledActionDescription *string `type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `type:"string"`

	// The start time in UTC when the schedule is active. Before this time, the
	// scheduled action does not trigger.
	StartTime *time.Time `type:"timestamp"`

	// The state of the scheduled action. For example, DISABLED.
	State ScheduledActionState `type:"string" enum:"true"`

	// A JSON format string of the Amazon Redshift API operation with input parameters.
	//
	// "{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}".
	TargetAction *ScheduledActionType `type:"structure"`
}

// String returns the string representation
func (s ScheduledAction) String() string {
	return awsutil.Prettify(s)
}

// A set of elements to filter the returned scheduled actions.
type ScheduledActionFilter struct {
	_ struct{} `type:"structure"`

	// The type of element to filter.
	//
	// Name is a required field
	Name ScheduledActionFilterName `type:"string" required:"true" enum:"true"`

	// List of values. Compare if the value (of type defined by Name) equals an
	// item in the list of scheduled actions.
	//
	// Values is a required field
	Values []string `locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s ScheduledActionFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledActionFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduledActionFilter"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The action type that specifies an Amazon Redshift API operation that is supported
// by the Amazon Redshift scheduler.
type ScheduledActionType struct {
	_ struct{} `type:"structure"`

	// An action that runs a PauseCluster API operation.
	PauseCluster *PauseClusterMessage `type:"structure"`

	// An action that runs a ResizeCluster API operation.
	ResizeCluster *ResizeClusterMessage `type:"structure"`

	// An action that runs a ResumeCluster API operation.
	ResumeCluster *ResumeClusterMessage `type:"structure"`
}

// String returns the string representation
func (s ScheduledActionType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledActionType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduledActionType"}
	if s.PauseCluster != nil {
		if err := s.PauseCluster.Validate(); err != nil {
			invalidParams.AddNested("PauseCluster", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResizeCluster != nil {
		if err := s.ResizeCluster.Validate(); err != nil {
			invalidParams.AddNested("ResizeCluster", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResumeCluster != nil {
		if err := s.ResumeCluster.Validate(); err != nil {
			invalidParams.AddNested("ResumeCluster", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a snapshot.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// A list of the AWS customer accounts authorized to restore the snapshot. Returns
	// null if no accounts are authorized. Visible only to the snapshot owner.
	AccountsWithRestoreAccess []AccountWithRestoreAccess `locationNameList:"AccountWithRestoreAccess" type:"list"`

	// The size of the incremental backup.
	ActualIncrementalBackupSizeInMegaBytes *float64 `type:"double"`

	// The Availability Zone in which the cluster was created.
	AvailabilityZone *string `type:"string"`

	// The number of megabytes that have been transferred to the snapshot backup.
	BackupProgressInMegaBytes *float64 `type:"double"`

	// The time (UTC) when the cluster was originally created.
	ClusterCreateTime *time.Time `type:"timestamp"`

	// The identifier of the cluster for which the snapshot was taken.
	ClusterIdentifier *string `type:"string"`

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string `type:"string"`

	// The number of megabytes per second being transferred to the snapshot backup.
	// Returns 0 for a completed backup.
	CurrentBackupRateInMegaBytesPerSecond *float64 `type:"double"`

	// The name of the database that was created when the cluster was created.
	DBName *string `type:"string"`

	// The amount of time an in-progress snapshot backup has been running, or the
	// amount of time it took a completed backup to finish.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// If true, the data in the snapshot is encrypted at rest.
	Encrypted *bool `type:"boolean"`

	// A boolean that indicates whether the snapshot data is encrypted using the
	// HSM keys of the source cluster. true indicates that the data is encrypted
	// using HSM keys.
	EncryptedWithHSM *bool `type:"boolean"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// The estimate of the time remaining before the snapshot backup will complete.
	// Returns 0 for a completed backup.
	EstimatedSecondsToCompletion *int64 `type:"long"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that was
	// used to encrypt data in the cluster from which the snapshot was taken.
	KmsKeyId *string `type:"string"`

	// The name of the maintenance track for the snapshot.
	MaintenanceTrackName *string `type:"string"`

	// The number of days until a manual snapshot will pass its retention period.
	ManualSnapshotRemainingDays *int64 `type:"integer"`

	// The number of days that a manual snapshot is retained. If the value is -1,
	// the manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The master user name for the cluster.
	MasterUsername *string `type:"string"`

	// The node type of the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// For manual snapshots, the AWS customer account used to create or copy the
	// snapshot. For automatic snapshots, the owner of the cluster. The owner can
	// perform all snapshot actions, such as sharing a manual snapshot.
	OwnerAccount *string `type:"string"`

	// The port that the cluster is listening on.
	Port *int64 `type:"integer"`

	// The list of node types that this cluster snapshot is able to restore into.
	RestorableNodeTypes []string `locationNameList:"NodeType" type:"list"`

	// The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot
	// contains a copy of the cluster data as of this exact time.
	SnapshotCreateTime *time.Time `type:"timestamp"`

	// The snapshot identifier that is provided in the request.
	SnapshotIdentifier *string `type:"string"`

	// A timestamp representing the start of the retention period for the snapshot.
	SnapshotRetentionStartTime *time.Time `type:"timestamp"`

	// The snapshot type. Snapshots created using CreateClusterSnapshot and CopyClusterSnapshot
	// are of type "manual".
	SnapshotType *string `type:"string"`

	// The source region from which the snapshot was copied.
	SourceRegion *string `type:"string"`

	// The snapshot status. The value of the status depends on the API operation
	// used:
	//
	//    * CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
	//
	//    * DescribeClusterSnapshots returns status as "creating", "available",
	//    "final snapshot", or "failed".
	//
	//    * DeleteClusterSnapshot returns status as "deleted".
	Status *string `type:"string"`

	// The list of tags for the cluster snapshot.
	Tags []Tag `locationNameList:"Tag" type:"list"`

	// The size of the complete set of backup data that would be used to restore
	// the cluster.
	TotalBackupSizeInMegaBytes *float64 `type:"double"`

	// The VPC identifier of the cluster if the snapshot is from a cluster in a
	// VPC. Otherwise, this field is not in the output.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// The snapshot copy grant that grants Amazon Redshift permission to encrypt
// copied snapshots with the specified customer master key (CMK) from AWS KMS
// in the destination region.
//
// For more information about managing snapshot copy grants, go to Amazon Redshift
// Database Encryption (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
type SnapshotCopyGrant struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the customer master key (CMK) in AWS KMS to which
	// Amazon Redshift is granted permission.
	KmsKeyId *string `type:"string"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`

	// A list of tag instances.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s SnapshotCopyGrant) String() string {
	return awsutil.Prettify(s)
}

// Describes the errors returned by a snapshot.
type SnapshotErrorMessage struct {
	_ struct{} `type:"structure"`

	// The failure code for the error.
	FailureCode *string `type:"string"`

	// The text message describing the error.
	FailureReason *string `type:"string"`

	// A unique identifier for the cluster.
	SnapshotClusterIdentifier *string `type:"string"`

	// A unique identifier for the snapshot returning the error.
	SnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s SnapshotErrorMessage) String() string {
	return awsutil.Prettify(s)
}

// Describes a snapshot schedule. You can set a regular interval for creating
// snapshots of a cluster. You can also schedule snapshots for specific dates.
type SnapshotSchedule struct {
	_ struct{} `type:"structure"`

	// The number of clusters associated with the schedule.
	AssociatedClusterCount *int64 `type:"integer"`

	// A list of clusters associated with the schedule. A maximum of 100 clusters
	// is returned.
	AssociatedClusters []ClusterAssociatedToSchedule `locationNameList:"ClusterAssociatedToSchedule" type:"list"`

	NextInvocations []time.Time `locationNameList:"SnapshotTime" type:"list"`

	// A list of ScheduleDefinitions.
	ScheduleDefinitions []string `locationNameList:"ScheduleDefinition" type:"list"`

	// The description of the schedule.
	ScheduleDescription *string `type:"string"`

	// A unique identifier for the schedule.
	ScheduleIdentifier *string `type:"string"`

	// An optional set of tags describing the schedule.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s SnapshotSchedule) String() string {
	return awsutil.Prettify(s)
}

// Describes a sorting entity
type SnapshotSortingEntity struct {
	_ struct{} `type:"structure"`

	// The category for sorting the snapshots.
	//
	// Attribute is a required field
	Attribute SnapshotAttributeToSortBy `type:"string" required:"true" enum:"true"`

	// The order for listing the attributes.
	SortOrder SortByOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s SnapshotSortingEntity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnapshotSortingEntity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SnapshotSortingEntity"}
	if len(s.Attribute) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Attribute"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a subnet.
type Subnet struct {
	_ struct{} `type:"structure"`

	// Describes an availability zone.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// The status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// Describes the operations that are allowed on a maintenance track.
type SupportedOperation struct {
	_ struct{} `type:"structure"`

	// A list of the supported operations.
	OperationName *string `type:"string"`
}

// String returns the string representation
func (s SupportedOperation) String() string {
	return awsutil.Prettify(s)
}

// A list of supported platforms for orderable clusters.
type SupportedPlatform struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s SupportedPlatform) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a RestoreTableFromClusterSnapshot operation.
type TableRestoreStatus struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift cluster that the table is being restored
	// to.
	ClusterIdentifier *string `type:"string"`

	// A description of the status of the table restore request. Status values include
	// SUCCEEDED, FAILED, CANCELED, PENDING, IN_PROGRESS.
	Message *string `type:"string"`

	// The name of the table to create as a result of the table restore request.
	NewTableName *string `type:"string"`

	// The amount of data restored to the new table so far, in megabytes (MB).
	ProgressInMegaBytes *int64 `type:"long"`

	// The time that the table restore request was made, in Universal Coordinated
	// Time (UTC).
	RequestTime *time.Time `type:"timestamp"`

	// The identifier of the snapshot that the table is being restored from.
	SnapshotIdentifier *string `type:"string"`

	// The name of the source database that contains the table being restored.
	SourceDatabaseName *string `type:"string"`

	// The name of the source schema that contains the table being restored.
	SourceSchemaName *string `type:"string"`

	// The name of the source table being restored.
	SourceTableName *string `type:"string"`

	// A value that describes the current state of the table restore request.
	//
	// Valid Values: SUCCEEDED, FAILED, CANCELED, PENDING, IN_PROGRESS
	Status TableRestoreStatusType `type:"string" enum:"true"`

	// The unique identifier for the table restore request.
	TableRestoreRequestId *string `type:"string"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `type:"string"`

	// The total amount of data to restore to the new table, in megabytes (MB).
	TotalDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s TableRestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// A tag consisting of a name/value pair for a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key, or name, for the resource tag.
	Key *string `type:"string"`

	// The value for the resource tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// A tag and its associated resource.
type TaggedResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) with which the tag is associated, for example:
	// arn:aws:redshift:us-east-2:123456789:cluster:t1.
	ResourceName *string `type:"string"`

	// The type of resource with which the tag is associated. Valid resource types
	// are:
	//
	//    * Cluster
	//
	//    * CIDR/IP
	//
	//    * EC2 security group
	//
	//    * Snapshot
	//
	//    * Cluster security group
	//
	//    * Subnet group
	//
	//    * HSM connection
	//
	//    * HSM certificate
	//
	//    * Parameter group
	//
	// For more information about Amazon Redshift resource types and constructing
	// ARNs, go to Constructing an Amazon Redshift Amazon Resource Name (ARN) (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions)
	// in the Amazon Redshift Cluster Management Guide.
	ResourceType *string `type:"string"`

	// The tag for the resource.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s TaggedResource) String() string {
	return awsutil.Prettify(s)
}

// A maintenance track that you can switch the current track to.
type UpdateTarget struct {
	_ struct{} `type:"structure"`

	// The cluster version for the new maintenance track.
	DatabaseVersion *string `type:"string"`

	// The name of the new maintenance track.
	MaintenanceTrackName *string `type:"string"`

	// A list of operations supported by the maintenance track.
	SupportedOperations []SupportedOperation `locationNameList:"SupportedOperation" type:"list"`
}

// String returns the string representation
func (s UpdateTarget) String() string {
	return awsutil.Prettify(s)
}

// Describes a usage limit object for a cluster.
type UsageLimit struct {
	_ struct{} `type:"structure"`

	// The limit amount. If time-based, this amount is in minutes. If data-based,
	// this amount is in terabytes (TB).
	Amount *int64 `type:"long"`

	// The action that Amazon Redshift takes when the limit is reached. Possible
	// values are:
	//
	//    * log - To log an event in a system table. The default is log.
	//
	//    * emit-metric - To emit CloudWatch metrics.
	//
	//    * disable - To disable the feature until the next usage period begins.
	BreachAction UsageLimitBreachAction `type:"string" enum:"true"`

	// The identifier of the cluster with a usage limit.
	ClusterIdentifier *string `type:"string"`

	// The Amazon Redshift feature to which the limit applies.
	FeatureType UsageLimitFeatureType `type:"string" enum:"true"`

	// The type of limit. Depending on the feature type, this can be based on a
	// time duration or data size.
	LimitType UsageLimitLimitType `type:"string" enum:"true"`

	// The time period that the amount applies to. A weekly period begins on Sunday.
	// The default is monthly.
	Period UsageLimitPeriod `type:"string" enum:"true"`

	// A list of tag instances.
	Tags []Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the usage limit.
	UsageLimitId *string `type:"string"`
}

// String returns the string representation
func (s UsageLimit) String() string {
	return awsutil.Prettify(s)
}

// Describes the members of a VPC security group.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The identifier of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}
