// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCelebrityRecognitionInput struct {
	_ struct{} `type:"structure"`

	// Job identifier for the required celebrity recognition analysis. You can get
	// the job identifer from a call to StartCelebrityRecognition.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000. If you specify a value greater than 1000, a maximum
	// of 1000 results is returned. The default value is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more recognized
	// celebrities to retrieve), Amazon Rekognition Video returns a pagination token
	// in the response. You can use this pagination token to retrieve the next set
	// of celebrities.
	NextToken *string `type:"string"`

	// Sort to use for celebrities returned in Celebrities field. Specify ID to
	// sort by the celebrity identifier, specify TIMESTAMP to sort by the time the
	// celebrity was recognized.
	SortBy CelebrityRecognitionSortBy `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetCelebrityRecognitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCelebrityRecognitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCelebrityRecognitionInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCelebrityRecognitionOutput struct {
	_ struct{} `type:"structure"`

	// Array of celebrities recognized in the video.
	Celebrities []CelebrityRecognition `type:"list"`

	// The current status of the celebrity recognition job.
	JobStatus VideoJobStatus `type:"string" enum:"true"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of celebrities.
	NextToken *string `type:"string"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Information about a video that Amazon Rekognition Video analyzed. Videometadata
	// is returned in every page of paginated responses from a Amazon Rekognition
	// Video operation.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation
func (s GetCelebrityRecognitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCelebrityRecognition = "GetCelebrityRecognition"

// GetCelebrityRecognitionRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Gets the celebrity recognition results for a Amazon Rekognition Video analysis
// started by StartCelebrityRecognition.
//
// Celebrity recognition in a video is an asynchronous operation. Analysis is
// started by a call to StartCelebrityRecognition which returns a job identifier
// (JobId). When the celebrity recognition operation finishes, Amazon Rekognition
// Video publishes a completion status to the Amazon Simple Notification Service
// topic registered in the initial call to StartCelebrityRecognition. To get
// the results of the celebrity recognition analysis, first check that the status
// value published to the Amazon SNS topic is SUCCEEDED. If so, call GetCelebrityDetection
// and pass the job identifier (JobId) from the initial call to StartCelebrityDetection.
//
// For more information, see Working With Stored Videos in the Amazon Rekognition
// Developer Guide.
//
// GetCelebrityRecognition returns detected celebrities and the time(s) they
// are detected in an array (Celebrities) of CelebrityRecognition objects. Each
// CelebrityRecognition contains information about the celebrity in a CelebrityDetail
// object and the time, Timestamp, the celebrity was detected.
//
// GetCelebrityRecognition only returns the default facial attributes (BoundingBox,
// Confidence, Landmarks, Pose, and Quality). The other facial attributes listed
// in the Face object of the following response syntax are not returned. For
// more information, see FaceDetail in the Amazon Rekognition Developer Guide.
//
// By default, the Celebrities array is sorted by time (milliseconds from the
// start of the video). You can also sort the array by celebrity by specifying
// the value ID in the SortBy input parameter.
//
// The CelebrityDetail object includes the celebrity identifer and additional
// information urls. If you don't store the additional information urls, you
// can get them later by calling GetCelebrityInfo with the celebrity identifer.
//
// No information is returned for faces not recognized as celebrities.
//
// Use MaxResults parameter to limit the number of labels returned. If there
// are more results than specified in MaxResults, the value of NextToken in
// the operation response contains a pagination token for getting the next set
// of results. To get the next page of results, call GetCelebrityDetection and
// populate the NextToken request parameter with the token value returned from
// the previous call to GetCelebrityRecognition.
//
//    // Example sending a request using GetCelebrityRecognitionRequest.
//    req := client.GetCelebrityRecognitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetCelebrityRecognitionRequest(input *GetCelebrityRecognitionInput) GetCelebrityRecognitionRequest {
	op := &aws.Operation{
		Name:       opGetCelebrityRecognition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCelebrityRecognitionInput{}
	}

	req := c.newRequest(op, input, &GetCelebrityRecognitionOutput{})

	return GetCelebrityRecognitionRequest{Request: req, Input: input, Copy: c.GetCelebrityRecognitionRequest}
}

// GetCelebrityRecognitionRequest is the request type for the
// GetCelebrityRecognition API operation.
type GetCelebrityRecognitionRequest struct {
	*aws.Request
	Input *GetCelebrityRecognitionInput
	Copy  func(*GetCelebrityRecognitionInput) GetCelebrityRecognitionRequest
}

// Send marshals and sends the GetCelebrityRecognition API request.
func (r GetCelebrityRecognitionRequest) Send(ctx context.Context) (*GetCelebrityRecognitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCelebrityRecognitionResponse{
		GetCelebrityRecognitionOutput: r.Request.Data.(*GetCelebrityRecognitionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetCelebrityRecognitionRequestPaginator returns a paginator for GetCelebrityRecognition.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetCelebrityRecognitionRequest(input)
//   p := rekognition.NewGetCelebrityRecognitionRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetCelebrityRecognitionPaginator(req GetCelebrityRecognitionRequest) GetCelebrityRecognitionPaginator {
	return GetCelebrityRecognitionPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetCelebrityRecognitionInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetCelebrityRecognitionPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetCelebrityRecognitionPaginator struct {
	aws.Pager
}

func (p *GetCelebrityRecognitionPaginator) CurrentPage() *GetCelebrityRecognitionOutput {
	return p.Pager.CurrentPage().(*GetCelebrityRecognitionOutput)
}

// GetCelebrityRecognitionResponse is the response type for the
// GetCelebrityRecognition API operation.
type GetCelebrityRecognitionResponse struct {
	*GetCelebrityRecognitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCelebrityRecognition request.
func (r *GetCelebrityRecognitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
