// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartProjectVersionInput struct {
	_ struct{} `type:"structure"`

	// The minimum number of inference units to use. A single inference unit represents
	// 1 hour of processing and can support up to 5 Transaction Pers Second (TPS).
	// Use a higher number to increase the TPS throughput of your model. You are
	// charged for the number of inference units that you use.
	//
	// MinInferenceUnits is a required field
	MinInferenceUnits *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name(ARN) of the model version that you want to start.
	//
	// ProjectVersionArn is a required field
	ProjectVersionArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s StartProjectVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartProjectVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartProjectVersionInput"}

	if s.MinInferenceUnits == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinInferenceUnits"))
	}
	if s.MinInferenceUnits != nil && *s.MinInferenceUnits < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MinInferenceUnits", 1))
	}

	if s.ProjectVersionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectVersionArn"))
	}
	if s.ProjectVersionArn != nil && len(*s.ProjectVersionArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectVersionArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartProjectVersionOutput struct {
	_ struct{} `type:"structure"`

	// The current running status of the model.
	Status ProjectVersionStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StartProjectVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartProjectVersion = "StartProjectVersion"

// StartProjectVersionRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Starts the running of the version of a model. Starting a model takes a while
// to complete. To check the current state of the model, use DescribeProjectVersions.
//
// Once the model is running, you can detect custom labels in new images by
// calling DetectCustomLabels.
//
// You are charged for the amount of time that the model is running. To stop
// a running model, call StopProjectVersion.
//
// This operation requires permissions to perform the rekognition:StartProjectVersion
// action.
//
//    // Example sending a request using StartProjectVersionRequest.
//    req := client.StartProjectVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) StartProjectVersionRequest(input *StartProjectVersionInput) StartProjectVersionRequest {
	op := &aws.Operation{
		Name:       opStartProjectVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartProjectVersionInput{}
	}

	req := c.newRequest(op, input, &StartProjectVersionOutput{})

	return StartProjectVersionRequest{Request: req, Input: input, Copy: c.StartProjectVersionRequest}
}

// StartProjectVersionRequest is the request type for the
// StartProjectVersion API operation.
type StartProjectVersionRequest struct {
	*aws.Request
	Input *StartProjectVersionInput
	Copy  func(*StartProjectVersionInput) StartProjectVersionRequest
}

// Send marshals and sends the StartProjectVersion API request.
func (r StartProjectVersionRequest) Send(ctx context.Context) (*StartProjectVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartProjectVersionResponse{
		StartProjectVersionOutput: r.Request.Data.(*StartProjectVersionOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartProjectVersionResponse is the response type for the
// StartProjectVersion API operation.
type StartProjectVersionResponse struct {
	*StartProjectVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartProjectVersion request.
func (r *StartProjectVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
