// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// The name of the stream processor to start processing.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStreamProcessorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartStreamProcessorInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartStreamProcessorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartStreamProcessor = "StartStreamProcessor"

// StartStreamProcessorRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Starts processing a stream processor. You create a stream processor by calling
// CreateStreamProcessor. To tell StartStreamProcessor which stream processor
// to start, use the value of the Name field specified in the call to CreateStreamProcessor.
//
//    // Example sending a request using StartStreamProcessorRequest.
//    req := client.StartStreamProcessorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) StartStreamProcessorRequest(input *StartStreamProcessorInput) StartStreamProcessorRequest {
	op := &aws.Operation{
		Name:       opStartStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartStreamProcessorInput{}
	}

	req := c.newRequest(op, input, &StartStreamProcessorOutput{})

	return StartStreamProcessorRequest{Request: req, Input: input, Copy: c.StartStreamProcessorRequest}
}

// StartStreamProcessorRequest is the request type for the
// StartStreamProcessor API operation.
type StartStreamProcessorRequest struct {
	*aws.Request
	Input *StartStreamProcessorInput
	Copy  func(*StartStreamProcessorInput) StartStreamProcessorRequest
}

// Send marshals and sends the StartStreamProcessor API request.
func (r StartStreamProcessorRequest) Send(ctx context.Context) (*StartStreamProcessorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartStreamProcessorResponse{
		StartStreamProcessorOutput: r.Request.Data.(*StartStreamProcessorOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartStreamProcessorResponse is the response type for the
// StartStreamProcessor API operation.
type StartStreamProcessorResponse struct {
	*StartStreamProcessorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartStreamProcessor request.
func (r *StartStreamProcessorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
